/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.system.health;

import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.time.Instant;
import org.cafienne.json.ValueMap;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005a\u0001\u0002\n\u0014\u0001qA\u0001\"\f\u0001\u0003\u0006\u0004%\tA\f\u0005\tu\u0001\u0011\t\u0011)A\u0005_!)1\b\u0001C\u0001y!9\u0001\t\u0001a\u0001\n\u0013\t\u0005bB#\u0001\u0001\u0004%IA\u0012\u0005\u0007\u0019\u0002\u0001\u000b\u0015\u0002\"\t\u000f5\u0003\u0001\u0019!C\u0005\u001d\"9a\u000b\u0001a\u0001\n\u00139\u0006BB-\u0001A\u0003&q\nC\u0004[\u0001\u0001\u0007I\u0011B.\t\u000f\t\u0004\u0001\u0019!C\u0005G\"1Q\r\u0001Q!\nqCQA\u001a\u0001\u0005\u0002\u001dDQ\u0001\u001b\u0001\u0005\u0002%DQA\u001b\u0001\u0005\u0002-DQa\u001e\u0001\u0005\u00029BQ\u0001\u001f\u0001\u0005\u0002e\u0014!\u0003S3bYRDW*Z1tkJ,\u0007k\\5oi*\u0011A#F\u0001\u0007Q\u0016\fG\u000e\u001e5\u000b\u0005Y9\u0012AB:zgR,WN\u0003\u0002\u00193\u0005A1-\u00194jK:tWMC\u0001\u001b\u0003\ry'oZ\u0002\u0001'\r\u0001Qd\t\t\u0003=\u0005j\u0011a\b\u0006\u0002A\u0005)1oY1mC&\u0011!e\b\u0002\u0007\u0003:L(+\u001a4\u0011\u0005\u0011ZS\"A\u0013\u000b\u0005\u0019:\u0013\u0001D:dC2\fGn\\4hS:<'B\u0001\u0015*\u0003!!\u0018\u0010]3tC\u001a,'\"\u0001\u0016\u0002\u0007\r|W.\u0003\u0002-K\tYA*\u0019>z\u0019><w-\u001b8h\u0003\rYW-_\u000b\u0002_A\u0011\u0001g\u000e\b\u0003cU\u0002\"AM\u0010\u000e\u0003MR!\u0001N\u000e\u0002\rq\u0012xn\u001c;?\u0013\t1t$\u0001\u0004Qe\u0016$WMZ\u0005\u0003qe\u0012aa\u0015;sS:<'B\u0001\u001c \u0003\u0011YW-\u001f\u0011\u0002\rqJg.\u001b;?)\tit\b\u0005\u0002?\u00015\t1\u0003C\u0003.\u0007\u0001\u0007q&A\u0004iK\u0006dG\u000f[=\u0016\u0003\t\u0003\"AH\"\n\u0005\u0011{\"a\u0002\"p_2,\u0017M\\\u0001\fQ\u0016\fG\u000e\u001e5z?\u0012*\u0017\u000f\u0006\u0002H\u0015B\u0011a\u0004S\u0005\u0003\u0013~\u0011A!\u00168ji\"91*BA\u0001\u0002\u0004\u0011\u0015a\u0001=%c\u0005A\u0001.Z1mi\"L\b%A\u0006eKN\u001c'/\u001b9uS>tW#A(\u0011\u0005A+V\"A)\u000b\u0005I\u001b\u0016\u0001\u00027b]\u001eT\u0011\u0001V\u0001\u0005U\u00064\u0018-\u0003\u00029#\u0006yA-Z:de&\u0004H/[8o?\u0012*\u0017\u000f\u0006\u0002H1\"91\nCA\u0001\u0002\u0004y\u0015\u0001\u00043fg\u000e\u0014\u0018\u000e\u001d;j_:\u0004\u0013aB2iC:<W\rZ\u000b\u00029B\u0011Q\fY\u0007\u0002=*\u0011qlU\u0001\u0005i&lW-\u0003\u0002b=\n9\u0011J\\:uC:$\u0018aC2iC:<W\rZ0%KF$\"a\u00123\t\u000f-[\u0011\u0011!a\u00019\u0006A1\r[1oO\u0016$\u0007%A\u0005v]\",\u0017\r\u001c;isR\t!)\u0001\u0003jg>[E#A$\u0002\u0013!\f7OR1jY\u0016$GCA$m\u0011\u0015iw\u00021\u0001o\u0003%!\bN]8xC\ndW\r\u0005\u0002pi:\u0011\u0001O\u001d\b\u0003eEL\u0011\u0001I\u0005\u0003g~\tq\u0001]1dW\u0006<W-\u0003\u0002vm\nIA\u000b\u001b:po\u0006\u0014G.\u001a\u0006\u0003g~\taa\u001d;biV\u001c\u0018AB1t\u0015N{e\nF\u0001{!\tYh0D\u0001}\u0015\tix#\u0001\u0003kg>t\u0017BA@}\u0005!1\u0016\r\\;f\u001b\u0006\u0004\b")
public class HealthMeasurePoint
implements LazyLogging {
    private final String key;
    private boolean healthy;
    private String description;
    private Instant changed;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        HealthMeasurePoint healthMeasurePoint = this;
        synchronized (healthMeasurePoint) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String key() {
        return this.key;
    }

    private boolean healthy() {
        return this.healthy;
    }

    private void healthy_$eq(boolean x$1) {
        this.healthy = x$1;
    }

    private String description() {
        return this.description;
    }

    private void description_$eq(String x$1) {
        this.description = x$1;
    }

    private Instant changed() {
        return this.changed;
    }

    private void changed_$eq(Instant x$1) {
        this.changed = x$1;
    }

    public boolean unhealthy() {
        return !this.healthy();
    }

    public void isOK() {
        block2: {
            BoxedUnit boxedUnit;
            if (this.healthy()) break block2;
            if (this.logger().underlying().isErrorEnabled()) {
                this.logger().underlying().error("{} is healthy health again", (Object)this.key());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            this.healthy_$eq(true);
            this.description_$eq(this.key() + " is healthy ");
            this.changed_$eq(Instant.now());
        }
    }

    public void hasFailed(Throwable throwable) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isErrorEnabled()) {
            this.logger().underlying().error("{} reported bad health", new Object[]{this.key(), throwable});
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        this.healthy_$eq(false);
        this.description_$eq("Failure: " + throwable.getLocalizedMessage());
        this.changed_$eq(Instant.now());
    }

    public String status() {
        return this.healthy() ? "OK" : "NOK";
    }

    /*
     * WARNING - void declaration
     */
    public ValueMap asJSON() {
        void var1_1;
        ValueMap json = new ValueMap("Status", this.status(), "Description", this.description());
        Object object = this.changed() != null ? json.plus("changed-at", this.changed()) : BoxedUnit.UNIT;
        return var1_1;
    }

    public HealthMeasurePoint(String key) {
        this.key = key;
        LazyLogging.$init$((LazyLogging)this);
        this.healthy = true;
        this.description = key + " is healthy ";
        this.changed = null;
    }
}

