/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.tenant.actorapi.command.platform;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.PlatformOwner;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;
import org.cafienne.tenant.TenantActor;
import org.cafienne.tenant.actorapi.command.TenantCommand;

@Manifest
public abstract class PlatformTenantCommand
extends TenantCommand {
    protected PlatformTenantCommand(PlatformOwner platformOwner, String string) {
        super(platformOwner.asTenantUser(string), string);
    }

    protected PlatformTenantCommand(ValueMap valueMap) {
        super(valueMap);
    }

    @Override
    public void validate(TenantActor tenantActor) throws InvalidCommandException {
        if (!Cafienne.isPlatformOwner(this.getUser())) {
            throw new AuthorizationException("Only platform owners can invoke platform commands");
        }
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
    }
}

