/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice;

import akka.Done;
import akka.Done$;
import akka.actor.ActorSystem;
import akka.persistence.query.Offset;
import akka.persistence.query.scaladsl.CurrentPersistenceIdsQuery;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerCleared;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerSet;
import org.cafienne.infrastructure.cqrs.ModelEventEnvelope;
import org.cafienne.infrastructure.cqrs.ReadJournalProvider;
import org.cafienne.infrastructure.cqrs.TaggedEventConsumer;
import org.cafienne.system.CaseSystem;
import org.cafienne.timerservice.TimerService;
import scala.Option;
import scala.Some;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005\u00054AAC\u0006\u0001%!A\u0011\u0005\u0001BC\u0002\u0013\u0005!\u0005\u0003\u0005(\u0001\t\u0005\t\u0015!\u0003$\u0011\u0015A\u0003\u0001\"\u0001*\u0011\u001da\u0003A1A\u0005B5Ba\u0001\u000e\u0001!\u0002\u0013q\u0003\"B\u001b\u0001\t\u00032\u0004bB$\u0001\u0005\u0004%\t\u0005\u0013\u0005\u0007)\u0002\u0001\u000b\u0011B%\t\u000bU\u0003A\u0011\t,\u0003\u001dQKW.\u001a:Fm\u0016tGoU5oW*\u0011A\"D\u0001\ri&lWM]:feZL7-\u001a\u0006\u0003\u001d=\t\u0001bY1gS\u0016tg.\u001a\u0006\u0002!\u0005\u0019qN]4\u0004\u0001M\u0019\u0001aE\r\u0011\u0005Q9R\"A\u000b\u000b\u0003Y\tQa]2bY\u0006L!\u0001G\u000b\u0003\r\u0005s\u0017PU3g!\tQr$D\u0001\u001c\u0015\taR$\u0001\u0003dcJ\u001c(B\u0001\u0010\u000e\u00039IgN\u001a:bgR\u0014Xo\u0019;ve\u0016L!\u0001I\u000e\u0003'Q\u000bwmZ3e\u000bZ,g\u000e^\"p]N,X.\u001a:\u0002\u0019QLW.\u001a:TKJ4\u0018nY3\u0016\u0003\r\u0002\"\u0001J\u0013\u000e\u0003-I!AJ\u0006\u0003\u0019QKW.\u001a:TKJ4\u0018nY3\u0002\u001bQLW.\u001a:TKJ4\u0018nY3!\u0003\u0019a\u0014N\\5u}Q\u0011!f\u000b\t\u0003I\u0001AQ!I\u0002A\u0002\r\n!bY1tKNK8\u000f^3n+\u0005q\u0003CA\u00183\u001b\u0005\u0001$BA\u0019\u000e\u0003\u0019\u0019\u0018p\u001d;f[&\u00111\u0007\r\u0002\u000b\u0007\u0006\u001cXmU=ti\u0016l\u0017aC2bg\u0016\u001c\u0016p\u001d;f[\u0002\n\u0011bZ3u\u001f\u001a47/\u001a;\u0015\u0003]\u00022\u0001O\u001e>\u001b\u0005I$B\u0001\u001e\u0016\u0003)\u0019wN\\2veJ,g\u000e^\u0005\u0003ye\u0012aAR;ukJ,\u0007C\u0001 F\u001b\u0005y$B\u0001!B\u0003\u0015\tX/\u001a:z\u0015\t\u00115)A\u0006qKJ\u001c\u0018n\u001d;f]\u000e,'\"\u0001#\u0002\t\u0005\\7.Y\u0005\u0003\r~\u0012aa\u00144gg\u0016$\u0018a\u0001;bOV\t\u0011\n\u0005\u0002K#:\u00111j\u0014\t\u0003\u0019Vi\u0011!\u0014\u0006\u0003\u001dF\ta\u0001\u0010:p_Rt\u0014B\u0001)\u0016\u0003\u0019\u0001&/\u001a3fM&\u0011!k\u0015\u0002\u0007'R\u0014\u0018N\\4\u000b\u0005A+\u0012\u0001\u0002;bO\u0002\n\u0011cY8ogVlW-T8eK2,e/\u001a8u)\t9F\fE\u00029wa\u0003\"!\u0017.\u000e\u0003\rK!aW\"\u0003\t\u0011{g.\u001a\u0005\u0006;&\u0001\rAX\u0001\tK:4X\r\\8qKB\u0011!dX\u0005\u0003An\u0011!#T8eK2,e/\u001a8u\u000b:4X\r\\8qK\u0002")
public class TimerEventSink
implements TaggedEventConsumer {
    private final TimerService timerService;
    private final CaseSystem caseSystem;
    private final String tag;
    private String configuredJournal;
    private String readJournalSetting;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public void start() {
        TaggedEventConsumer.start$(this);
    }

    @Override
    public Future<Done> runStream() {
        return TaggedEventConsumer.runStream$(this);
    }

    @Override
    public ActorSystem system() {
        return ReadJournalProvider.system$(this);
    }

    @Override
    public CurrentPersistenceIdsQuery journal() {
        return ReadJournalProvider.journal$(this);
    }

    private String configuredJournal$lzycompute() {
        TimerEventSink timerEventSink = this;
        synchronized (timerEventSink) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.configuredJournal = ReadJournalProvider.configuredJournal$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.configuredJournal;
    }

    @Override
    public String configuredJournal() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.configuredJournal$lzycompute() : this.configuredJournal;
    }

    private String readJournalSetting$lzycompute() {
        TimerEventSink timerEventSink = this;
        synchronized (timerEventSink) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.readJournalSetting = ReadJournalProvider.readJournalSetting$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.readJournalSetting;
    }

    @Override
    public String readJournalSetting() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.readJournalSetting$lzycompute() : this.readJournalSetting;
    }

    private Logger logger$lzycompute() {
        TimerEventSink timerEventSink = this;
        synchronized (timerEventSink) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public TimerService timerService() {
        return this.timerService;
    }

    @Override
    public CaseSystem caseSystem() {
        return this.caseSystem;
    }

    @Override
    public Future<Offset> getOffset() {
        return this.timerService().storage.getOffset();
    }

    @Override
    public String tag() {
        return this.tag;
    }

    @Override
    public Future<Done> consumeModelEvent(ModelEventEnvelope envelope) {
        Future<Done> future;
        ModelEvent modelEvent = envelope.event();
        if (modelEvent instanceof TimerSet) {
            BoxedUnit boxedUnit;
            TimerSet timerSet = (TimerSet)modelEvent;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{} on timer {} in case {} (triggering at {})", new Object[]{timerSet.getClass().getSimpleName(), timerSet.getTimerId(), timerSet.getActorId(), timerSet.getTargetMoment()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.timerService().monitor.addTimer(timerSet, envelope.offset());
        } else if (modelEvent instanceof TimerCleared) {
            BoxedUnit boxedUnit;
            TimerCleared timerCleared = (TimerCleared)modelEvent;
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("{} on timer {} in case {}", new Object[]{timerCleared.getClass().getSimpleName(), timerCleared.getTimerId(), timerCleared.getActorId()});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = this.timerService().monitor.removeTimer(timerCleared.getTimerId(), (Option<Offset>)new Some((Object)envelope.offset()));
        } else {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isWarnEnabled()) {
                this.logger().underlying().warn("Timer Service received an unexpected event of type {}", (Object)modelEvent.getClass().getName());
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            future = Future$.MODULE$.successful((Object)Done$.MODULE$);
        }
        return future;
    }

    public TimerEventSink(TimerService timerService) {
        this.timerService = timerService;
        LazyLogging.$init$((LazyLogging)this);
        ReadJournalProvider.$init$(this);
        TaggedEventConsumer.$init$(this);
        this.caseSystem = timerService.caseSystem;
        this.tag = "cafienne:timer";
    }
}

