/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice.persistence.cassandra;

import akka.Done;
import akka.Done$;
import akka.persistence.cassandra.query.scaladsl.CassandraReadJournal;
import akka.persistence.query.Offset;
import akka.persistence.query.Offset$;
import akka.persistence.query.TimeBasedUUID;
import akka.util.Timeout;
import com.datastax.driver.core.BatchStatement;
import com.datastax.driver.core.DataType;
import com.datastax.driver.core.Statement;
import com.datastax.driver.core.TypeCodec;
import com.datastax.driver.core.querybuilder.Delete;
import com.datastax.driver.core.querybuilder.Insert;
import com.datastax.driver.core.querybuilder.QueryBuilder;
import com.datastax.driver.core.querybuilder.Select;
import com.datastax.driver.core.schemabuilder.Create;
import com.datastax.driver.core.schemabuilder.SchemaBuilder;
import com.datastax.driver.core.schemabuilder.SchemaStatement;
import com.datastax.driver.extras.codecs.jdk8.InstantCodec;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import java.util.UUID;
import org.cafienne.infrastructure.cqrs.OffsetRecord;
import org.cafienne.infrastructure.cqrs.OffsetRecord$;
import org.cafienne.timerservice.Timer;
import org.cafienne.timerservice.persistence.TimerStore;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnceOps;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.ExecutionContext$;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;

@ScalaSignature(bytes="\u0006\u0005\u0005\u0005e\u0001\u0002\u000b\u0016\u0001\u0001B\u0001b\u000b\u0001\u0003\u0002\u0003\u0006I\u0001\f\u0005\u0006q\u0001!\t!\u000f\u0005\b{\u0001\u0011\r\u0011\"\u0001?\u0011\u0019Q\u0005\u0001)A\u0005\u007f!91\n\u0001b\u0001\n\u0003a\u0005B\u0002+\u0001A\u0003%Q\nC\u0004V\u0001\t\u0007I\u0011\u0001'\t\rY\u0003\u0001\u0015!\u0003N\u0011\u001d9\u0006A1A\u0005\u0002aCaa\u0018\u0001!\u0002\u0013I\u0006b\u00021\u0001\u0005\u0004%\u0019%\u0019\u0005\u0007Q\u0002\u0001\u000b\u0011\u00022\t\u000b%\u0004A\u0011\t6\t\u000bM\u0004A\u0011\t;\t\u000f\u0005]\u0001\u0001\"\u0011\u0002\u001a!9\u00111\u0007\u0001\u0005\n\u0005U\u0002bBA+\u0001\u0011%\u0011q\u000b\u0005\b\u0003_\u0002A\u0011IA9\u0011\u001d\tI\b\u0001C!\u0003w\u00121cQ1tg\u0006tGM]1US6,'o\u0015;pe\u0016T!AF\f\u0002\u0013\r\f7o]1oIJ\f'B\u0001\r\u001a\u0003-\u0001XM]:jgR,gnY3\u000b\u0005iY\u0012\u0001\u0004;j[\u0016\u00148/\u001a:wS\u000e,'B\u0001\u000f\u001e\u0003!\u0019\u0017MZ5f]:,'\"\u0001\u0010\u0002\u0007=\u0014xm\u0001\u0001\u0014\u0007\u0001\ts\u0005\u0005\u0002#K5\t1EC\u0001%\u0003\u0015\u00198-\u00197b\u0013\t13E\u0001\u0004B]f\u0014VM\u001a\t\u0003Q%j\u0011aF\u0005\u0003U]\u0011!\u0002V5nKJ\u001cFo\u001c:f\u0003-\u0011X-\u00193K_V\u0014h.\u00197\u0011\u000552T\"\u0001\u0018\u000b\u0005=\u0002\u0014\u0001C:dC2\fGm\u001d7\u000b\u0005E\u0012\u0014!B9vKJL(B\u0001\f4\u0015\tABGC\u00016\u0003\u0011\t7n[1\n\u0005]r#\u0001F\"bgN\fg\u000e\u001a:b%\u0016\fGMS8ve:\fG.\u0001\u0004=S:LGO\u0010\u000b\u0003uq\u0002\"a\u000f\u0001\u000e\u0003UAQa\u000b\u0002A\u00021\n\u0001b[3zgB\f7-Z\u000b\u0002\u007fA\u0011\u0001i\u0012\b\u0003\u0003\u0016\u0003\"AQ\u0012\u000e\u0003\rS!\u0001R\u0010\u0002\rq\u0012xn\u001c;?\u0013\t15%\u0001\u0004Qe\u0016$WMZ\u0005\u0003\u0011&\u0013aa\u0015;sS:<'B\u0001$$\u0003%YW-_:qC\u000e,\u0007%\u0001\u0006uS6,'\u000fV1cY\u0016,\u0012!\u0014\t\u0003\u001dNk\u0011a\u0014\u0006\u0003!F\u000bA\u0001\\1oO*\t!+\u0001\u0003kCZ\f\u0017B\u0001%P\u0003-!\u0018.\\3s)\u0006\u0014G.\u001a\u0011\u0002\u0017=4gm]3u)\u0006\u0014G.Z\u0001\r_\u001a47/\u001a;UC\ndW\rI\u0001\u0011G\u0006\u001c8/\u00198ee\u0006$\u0016.\\3pkR,\u0012!\u0017\t\u00035vk\u0011a\u0017\u0006\u00039R\nA!\u001e;jY&\u0011al\u0017\u0002\b)&lWm\\;u\u0003E\u0019\u0017m]:b]\u0012\u0014\u0018\rV5nK>,H\u000fI\u0001\u0003K\u000e,\u0012A\u0019\t\u0003G\u001al\u0011\u0001\u001a\u0006\u0003K\u000e\n!bY8oGV\u0014(/\u001a8u\u0013\t9GM\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Qm\u0019\u0011\u0002\u0013\u001d,Go\u00144gg\u0016$H#A6\u0011\u0007\rdg.\u0003\u0002nI\n1a)\u001e;ve\u0016\u0004\"a\\9\u000e\u0003AT!!M\u001a\n\u0005I\u0004(AB(gMN,G/A\u0005hKR$\u0016.\\3sgR\u0019Q/a\u0002\u0011\u0007\rdg\u000fE\u0002xy~t!\u0001\u001f>\u000f\u0005\tK\u0018\"\u0001\u0013\n\u0005m\u001c\u0013a\u00029bG.\fw-Z\u0005\u0003{z\u00141aU3r\u0015\tY8\u0005\u0005\u0003\u0002\u0002\u0005\rQ\"A\r\n\u0007\u0005\u0015\u0011DA\u0003US6,'\u000fC\u0004\u0002\n9\u0001\r!a\u0003\u0002\r]Lg\u000eZ8x!\u0011\ti!a\u0005\u000e\u0005\u0005=!bAA\t#\u0006!A/[7f\u0013\u0011\t)\"a\u0004\u0003\u000f%s7\u000f^1oi\u0006Q1\u000f^8sKRKW.\u001a:\u0015\r\u0005m\u0011QEA\u0015!\u0011\u0019G.!\b\u0011\t\u0005}\u0011\u0011E\u0007\u0002i%\u0019\u00111\u0005\u001b\u0003\t\u0011{g.\u001a\u0005\u0007\u0003Oy\u0001\u0019A@\u0002\u0007)|'\rC\u0004\u0002,=\u0001\r!!\f\u0002\r=4gm]3u!\u0011\u0011\u0013q\u00068\n\u0007\u0005E2E\u0001\u0004PaRLwN\\\u0001\u0013O\u0016$\u0018J\\:feR\u001cF/\u0019;f[\u0016tG\u000f\u0006\u0003\u00028\u0005M\u0003\u0003BA\u001d\u0003\u001fj!!a\u000f\u000b\t\u0005u\u0012qH\u0001\rcV,'/\u001f2vS2$WM\u001d\u0006\u0005\u0003\u0003\n\u0019%\u0001\u0003d_J,'\u0002BA#\u0003\u000f\na\u0001\u001a:jm\u0016\u0014(\u0002BA%\u0003\u0017\n\u0001\u0002Z1uCN$\u0018\r\u001f\u0006\u0003\u0003\u001b\n1aY8n\u0013\u0011\t\t&a\u000f\u0003\r%s7/\u001a:u\u0011\u0019\t9\u0003\u0005a\u0001\u007f\u0006\u0011\u0012\r\u001a3PM\u001a\u001cX\r^*uCR,W.\u001a8u)\u0019\tI&a\u0018\u0002lA\u0019!%a\u0017\n\u0007\u0005u3E\u0001\u0003V]&$\bbBA1#\u0001\u0007\u00111M\u0001\u0006E\u0006$8\r\u001b\t\u0005\u0003K\n9'\u0004\u0002\u0002@%!\u0011\u0011NA \u00059\u0011\u0015\r^2i'R\fG/Z7f]RDq!!\u001c\u0012\u0001\u0004\ti#\u0001\bpaRLwN\\1m\u001f\u001a47/\u001a;\u0002\u0017I,Wn\u001c<f)&lWM\u001d\u000b\u0007\u00037\t\u0019(a\u001e\t\r\u0005U$\u00031\u0001@\u0003\u001d!\u0018.\\3s\u0013\u0012Dq!a\u000b\u0013\u0001\u0004\ti#\u0001\u0007j[B|'\u000f\u001e+j[\u0016\u00148\u000f\u0006\u0003\u0002Z\u0005u\u0004BBA@'\u0001\u0007a/\u0001\u0003mSN$\b")
public class CassandraTimerStore
implements TimerStore {
    private final CassandraReadJournal readJournal;
    private final String keyspace;
    private final String timerTable;
    private final String offsetTable;
    private final Timeout cassandraTimeout;
    private final ExecutionContext ec;
    private String storageName;
    private String description;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile boolean bitmap$0;

    @Override
    public String storageName() {
        return this.storageName;
    }

    private String description$lzycompute() {
        CassandraTimerStore cassandraTimerStore = this;
        synchronized (cassandraTimerStore) {
            if (!this.bitmap$0) {
                this.description = TimerStore.description$(this);
                this.bitmap$0 = true;
            }
        }
        return this.description;
    }

    @Override
    public String description() {
        return !this.bitmap$0 ? this.description$lzycompute() : this.description;
    }

    @Override
    public void org$cafienne$timerservice$persistence$TimerStore$_setter_$ec_$eq(ExecutionContext x$1) {
    }

    @Override
    public void org$cafienne$timerservice$persistence$TimerStore$_setter_$storageName_$eq(String x$1) {
        this.storageName = x$1;
    }

    private Logger logger$lzycompute() {
        CassandraTimerStore cassandraTimerStore = this;
        synchronized (cassandraTimerStore) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public String keyspace() {
        return this.keyspace;
    }

    public String timerTable() {
        return this.timerTable;
    }

    public String offsetTable() {
        return this.offsetTable;
    }

    public Timeout cassandraTimeout() {
        return this.cassandraTimeout;
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public Future<Offset> getOffset() {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Reading timer offset from Cassandra");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.readJournal.session().selectOne("SELECT offset_value FROM " + this.keyspace() + "." + this.offsetTable() + " where name = ?", (Seq)ScalaRunTime$.MODULE$.wrapRefArray(new Object[]{this.storageName()})).map((Function1 & Serializable)result -> (Offset)result.fold((Function0 & Serializable)() -> Offset$.MODULE$.noOffset(), (Function1 & Serializable)row -> {
            String offsetValue = row.getString("offset_value");
            return new TimeBasedUUID(UUID.fromString(offsetValue));
        }), this.ec());
    }

    @Override
    public Future<Seq<Timer>> getTimers(Instant window) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Reading existing timers from Cassandra database for window {}", (Object)window);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Select select = QueryBuilder.select().from(this.keyspace(), this.timerTable()).where(QueryBuilder.lte((String)"moment", (Object)window)).allowFiltering();
        return this.readJournal.session().selectAll((Statement)select).map((Function1 & Serializable)rows -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Found " + rows.length() + " timers");
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return (Seq)((IterableOps)rows.map((Function1 & Serializable)row -> {
                Timer timer;
                String timerId = row.getString("timerid");
                String caseInstanceId = row.getString("caseinstanceid");
                String tenant = row.getString("tenant");
                String userId = row.getString("user");
                Date moment = row.getTimestamp("moment");
                if (timerId == null || caseInstanceId == null || tenant == null || userId == null || moment == null) {
                    BoxedUnit boxedUnit;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Cassandra database table contains an invalid record ({}, {}, {}, {}, {}). Record will be ignored", new Object[]{timerId, caseInstanceId, tenant, userId, moment});
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    timer = null;
                } else {
                    timer = new Timer(caseInstanceId, timerId, moment.toInstant(), userId);
                }
                return timer;
            })).filter((Function1 & Serializable)x$1 -> BoxesRunTime.boxToBoolean((boolean)CassandraTimerStore.$anonfun$getTimers$3(x$1)));
        }, this.ec());
    }

    @Override
    public Future<Done> storeTimer(Timer job, Option<Offset> offset) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Storing timer into Cassandra timer table " + job);
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)this.getInsertStatement(job));
        this.addOffsetStatement(batch, offset);
        return this.readJournal.session().executeWriteBatch(batch).map((Function1 & Serializable)x$2 -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Stored timer " + job);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Done$.MODULE$;
        }, this.ec());
    }

    private Insert getInsertStatement(Timer job) {
        return QueryBuilder.insertInto((String)this.keyspace(), (String)"cafienne_timer").value("timerid", (Object)job.timerId()).value("caseinstanceid", (Object)job.caseInstanceId()).value("tenant", (Object)"").value("user", (Object)job.userId()).value("moment", (Object)job.moment());
    }

    private void addOffsetStatement(BatchStatement batch, Option<Offset> optionalOffset) {
        optionalOffset.map((Function1 & Serializable)offset -> {
            OffsetRecord offsetRecord = OffsetRecord$.MODULE$.apply(this.storageName(), (Offset)offset);
            Insert record = QueryBuilder.insertInto((String)this.keyspace(), (String)"cafienne_timer_offset").value("name", (Object)this.storageName()).value("offset_type", (Object)offsetRecord.offsetType()).value("offset_value", (Object)offsetRecord.offsetValue()).value("modified", (Object)offsetRecord.timestamp());
            return batch.add((Statement)record);
        });
    }

    @Override
    public Future<Done> removeTimer(String timerId, Option<Offset> offset) {
        BoxedUnit boxedUnit;
        Delete.Where delete = QueryBuilder.delete().all().from(this.keyspace(), this.timerTable()).where(QueryBuilder.eq((String)"timerId", (Object)timerId));
        if (this.logger().underlying().isDebugEnabled()) {
            if (this.logger().underlying().isDebugEnabled()) {
                this.logger().underlying().debug("Removing timer {} from Cassandra database with statement {}", new Object[]{timerId, delete});
                boxedUnit = BoxedUnit.UNIT;
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        BatchStatement batch = new BatchStatement();
        batch.add((Statement)delete);
        this.addOffsetStatement(batch, offset);
        return this.readJournal.session().executeWriteBatch(batch).map((Function1 & Serializable)x$3 -> {
            BoxedUnit boxedUnit;
            if (this.logger().underlying().isDebugEnabled()) {
                if (this.logger().underlying().isDebugEnabled()) {
                    this.logger().underlying().debug("Removed timer {} from Cassandra database", (Object)timerId);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
            } else {
                boxedUnit = BoxedUnit.UNIT;
            }
            return Done$.MODULE$;
        }, this.ec());
    }

    @Override
    public void importTimers(Seq<Timer> list) {
        BatchStatement batch = new BatchStatement();
        ((IterableOnceOps)list.map((Function1 & Serializable)job -> this.getInsertStatement((Timer)job))).foreach((Function1 & Serializable)statement -> batch.add((Statement)statement));
        Await$.MODULE$.result((Awaitable)this.readJournal.session().executeWriteBatch(batch), (Duration)this.cassandraTimeout().duration());
    }

    public static final /* synthetic */ boolean $anonfun$getTimers$3(Timer x$1) {
        return x$1 != null;
    }

    public CassandraTimerStore(CassandraReadJournal readJournal) {
        BoxedUnit boxedUnit;
        BoxedUnit boxedUnit2;
        BoxedUnit boxedUnit3;
        BoxedUnit boxedUnit4;
        this.readJournal = readJournal;
        LazyLogging.$init$((LazyLogging)this);
        TimerStore.$init$(this);
        this.keyspace = "akka";
        this.timerTable = "cafienne_timer";
        this.offsetTable = "cafienne_timer_offset";
        this.cassandraTimeout = new Timeout(new package.DurationInt(package$.MODULE$.DurationInt(15)).seconds());
        this.ec = ExecutionContext$.MODULE$.global();
        readJournal.session().underlying().map((Function1 & Serializable)s -> s.getCluster().getConfiguration().getCodecRegistry().register((TypeCodec)InstantCodec.instance), this.ec());
        Create timerDDL = (Create)((Create)SchemaBuilder.createTable((String)this.keyspace(), (String)this.timerTable()).ifNotExists()).addPartitionKey("timerId", DataType.text()).addColumn("caseInstanceId", DataType.text()).addColumn("tenant", DataType.text()).addColumn("user", DataType.text()).addColumn("moment", DataType.timestamp());
        SchemaStatement indexOnMoment = SchemaBuilder.createIndex((String)"moment_indexed").onTable(this.keyspace(), this.offsetTable()).andColumn("moment");
        Create offsetDDL = (Create)((Create)SchemaBuilder.createTable((String)this.keyspace(), (String)this.offsetTable()).ifNotExists()).addPartitionKey("name", DataType.text()).addColumn("offset_type", DataType.text()).addColumn("offset_value", DataType.text()).addColumn("modified", DataType.timestamp());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Creating table " + this.timerTable() + ": " + timerDDL);
            boxedUnit4 = BoxedUnit.UNIT;
        } else {
            boxedUnit4 = BoxedUnit.UNIT;
        }
        readJournal.session().executeDDL(timerDDL.toString());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Adding index to column 'moment' in table " + this.timerTable() + ": " + indexOnMoment);
            boxedUnit3 = BoxedUnit.UNIT;
        } else {
            boxedUnit3 = BoxedUnit.UNIT;
        }
        readJournal.session().executeDDL(indexOnMoment.toString());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Creating table " + this.offsetTable() + ": " + offsetDDL);
            boxedUnit2 = BoxedUnit.UNIT;
        } else {
            boxedUnit2 = BoxedUnit.UNIT;
        }
        Await$.MODULE$.result((Awaitable)readJournal.session().executeDDL(offsetDDL.toString()), (Duration)this.cassandraTimeout().duration());
        if (this.logger().underlying().isInfoEnabled()) {
            this.logger().underlying().info("Completed Cassandra table creation");
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        Statics.releaseFence();
    }
}

