/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.timerservice.persistence.jdbc;

import akka.Done;
import akka.Done$;
import akka.persistence.query.Offset;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.time.Instant;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.infrastructure.cqrs.OffsetRecord;
import org.cafienne.infrastructure.cqrs.OffsetRecord$;
import org.cafienne.infrastructure.cqrs.OffsetStorage;
import org.cafienne.infrastructure.jdbc.CafienneJDBCConfig;
import org.cafienne.infrastructure.jdbc.cqrs.JDBCOffsetStorage;
import org.cafienne.infrastructure.jdbc.cqrs.OffsetStoreTables;
import org.cafienne.timerservice.Timer;
import org.cafienne.timerservice.persistence.TimerStore;
import org.cafienne.timerservice.persistence.jdbc.TimerServiceRecord;
import org.cafienne.timerservice.persistence.jdbc.TimerServiceTables;
import scala.Function0;
import scala.Function1;
import scala.Option;
import scala.collection.IterableOnce;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Seq$;
import scala.concurrent.Await$;
import scala.concurrent.Awaitable;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.duration.Duration;
import scala.concurrent.duration.package;
import scala.package$;
import scala.reflect.ClassTag$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.ScalaRunTime$;
import scala.runtime.Statics;
import slick.ast.BaseTypedType;
import slick.ast.TypedType;
import slick.basic.DatabaseConfig;
import slick.basic.DatabaseConfig$;
import slick.dbio.DBIOAction;
import slick.dbio.Effect;
import slick.dbio.NoStream;
import slick.jdbc.JdbcActionComponent;
import slick.jdbc.JdbcBackend;
import slick.jdbc.JdbcProfile;
import slick.lifted.BaseColumnExtensionMethods;
import slick.lifted.CanBeQueryCondition$;
import slick.lifted.OptionMapper2$;
import slick.lifted.Query;
import slick.lifted.Rep;
import slick.lifted.TableQuery;
import slick.lifted.TableQuery$;
import slick.lifted.Tag;
import slick.migration.api.Dialect;
import slick.migration.api.MigrationSeq;
import slick.sql.SqlAction;

@ScalaSignature(bytes="\u0006\u0005\u0005uc\u0001\u0002\u0006\f\u0001YAQA\r\u0001\u0005\u0002MB\u0001\"\u000e\u0001\t\u0006\u0004%\tE\u000e\u0005\b\t\u0002\u0011\r\u0011b\u0011F\u0011\u0019a\u0005\u0001)A\u0005\r\")Q\n\u0001C!\u001d\")A\u000e\u0001C![\"9\u0011q\u0001\u0001\u0005B\u0005%\u0001bBA\u0011\u0001\u0011%\u00111\u0005\u0005\b\u0003\u001f\u0002A\u0011IA)\u00059QEIQ\"US6,'o\u0015;pe\u0016T!\u0001D\u0007\u0002\t)$'m\u0019\u0006\u0003\u001d=\t1\u0002]3sg&\u001cH/\u001a8dK*\u0011\u0001#E\u0001\ri&lWM]:feZL7-\u001a\u0006\u0003%M\t\u0001bY1gS\u0016tg.\u001a\u0006\u0002)\u0005\u0019qN]4\u0004\u0001M1\u0001aF\u000f\"U9\u0002\"\u0001G\u000e\u000e\u0003eQ\u0011AG\u0001\u0006g\u000e\fG.Y\u0005\u00039e\u0011a!\u00118z%\u00164\u0007C\u0001\u0010 \u001b\u0005i\u0011B\u0001\u0011\u000e\u0005)!\u0016.\\3s'R|'/\u001a\t\u0003E!j\u0011a\t\u0006\u0003I\u0015\nAaY9sg*\u0011AB\n\u0006\u0003OE\ta\"\u001b8ge\u0006\u001cHO];diV\u0014X-\u0003\u0002*G\t\t\"\n\u0012\"D\u001f\u001a47/\u001a;Ti>\u0014\u0018mZ3\u0011\u0005-bS\"A\u0013\n\u00055*#AE\"bM&,gN\\3K\t\n\u001b5i\u001c8gS\u001e\u0004\"a\f\u0019\u000e\u0003-I!!M\u0006\u0003%QKW.\u001a:TKJ4\u0018nY3UC\ndWm]\u0001\u0007y%t\u0017\u000e\u001e \u0015\u0003Q\u0002\"a\f\u0001\u0002\u0011\u0011\u00147i\u001c8gS\u001e,\u0012a\u000e\t\u0004quzT\"A\u001d\u000b\u0005iZ\u0014!\u00022bg&\u001c'\"\u0001\u001f\u0002\u000bMd\u0017nY6\n\u0005yJ$A\u0004#bi\u0006\u0014\u0017m]3D_:4\u0017n\u001a\t\u0003\u0001\nk\u0011!\u0011\u0006\u0003\u0019mJ!aQ!\u0003\u0017)#'m\u0019)s_\u001aLG.Z\u0001\u0003K\u000e,\u0012A\u0012\t\u0003\u000f*k\u0011\u0001\u0013\u0006\u0003\u0013f\t!bY8oGV\u0014(/\u001a8u\u0013\tY\u0005J\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u0006\u0019Qm\u0019\u0011\u0002\u0013\u001d,G\u000fV5nKJ\u001cHCA(c!\r9\u0005KU\u0005\u0003#\"\u0013aAR;ukJ,\u0007cA*\\=:\u0011A+\u0017\b\u0003+bk\u0011A\u0016\u0006\u0003/V\ta\u0001\u0010:p_Rt\u0014\"\u0001\u000e\n\u0005iK\u0012a\u00029bG.\fw-Z\u0005\u00039v\u00131aU3r\u0015\tQ\u0016\u0004\u0005\u0002`A6\tq\"\u0003\u0002b\u001f\t)A+[7fe\")1-\u0002a\u0001I\u00061q/\u001b8e_^\u0004\"!\u001a6\u000e\u0003\u0019T!a\u001a5\u0002\tQLW.\u001a\u0006\u0002S\u0006!!.\u0019<b\u0013\tYgMA\u0004J]N$\u0018M\u001c;\u0002\u0015M$xN]3US6,'\u000fF\u0002ok^\u00042a\u0012)p!\t\u00018/D\u0001r\u0015\u0005\u0011\u0018\u0001B1lW\u0006L!\u0001^9\u0003\t\u0011{g.\u001a\u0005\u0006m\u001a\u0001\rAX\u0001\u0004U>\u0014\u0007\"\u0002=\u0007\u0001\u0004I\u0018AB8gMN,G\u000fE\u0002\u0019urL!a_\r\u0003\r=\u0003H/[8o!\ri\u00181A\u0007\u0002}*\u0019q0!\u0001\u0002\u000bE,XM]=\u000b\u00059\t\u0018bAA\u0003}\n1qJ\u001a4tKR\f1B]3n_Z,G+[7feR)a.a\u0003\u0002 !9\u0011QB\u0004A\u0002\u0005=\u0011a\u0002;j[\u0016\u0014\u0018\n\u001a\t\u0005\u0003#\tIB\u0004\u0003\u0002\u0014\u0005U\u0001CA+\u001a\u0013\r\t9\"G\u0001\u0007!J,G-\u001a4\n\t\u0005m\u0011Q\u0004\u0002\u0007'R\u0014\u0018N\\4\u000b\u0007\u0005]\u0011\u0004C\u0003y\u000f\u0001\u0007\u00110\u0001\u0004d_6l\u0017\u000e\u001e\u000b\u0006]\u0006\u0015\u0012q\u0005\u0005\u0006q\"\u0001\r!\u001f\u0005\b\u0003SA\u0001\u0019AA\u0016\u0003\u0019\t7\r^5p]B1\u0011QFA\u001f\u0003\u0013rA!a\f\u0002:9!\u0011\u0011GA\u001b\u001d\r\t\u0019DA\u0007\u0002\u0001%\u0019\u0011qG\u001f\u0002\u000fA\u0014xNZ5mK&\u0019\u00111\b\"\u0002\u0007\u0005\u0004\u0018.\u0003\u0003\u0002@\u0005\u0005#\u0001\u0002#C\u0013>KA!a\u0011\u0002F\t9\u0011\t\\5bg\u0016\u001c(bAA$w\u00051A.\u001b4uK\u0012\u00042\u0001GA&\u0013\r\ti%\u0007\u0002\u0004\u0013:$\u0018\u0001D5na>\u0014H\u000fV5nKJ\u001cH\u0003BA*\u00033\u00022\u0001GA+\u0013\r\t9&\u0007\u0002\u0005+:LG\u000f\u0003\u0004\u0002\\%\u0001\rAU\u0001\u0005Y&\u001cH\u000f")
public class JDBCTimerStore
implements TimerStore,
JDBCOffsetStorage,
TimerServiceTables {
    private DatabaseConfig<JdbcProfile> dbConfig;
    private final ExecutionContext ec;
    private TableQuery<OffsetStoreTables.OffsetStoreTable> offsetQuery;
    private JdbcBackend.DatabaseDef db;
    private boolean isSQLServer;
    private Dialect<? extends JdbcProfile> dialect;
    private String storageName;
    private String description;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;
    private volatile byte bitmap$0;

    @Override
    public Future<Offset> getOffset() {
        return JDBCOffsetStorage.getOffset$(this);
    }

    @Override
    public <CT extends CafienneJDBCConfig.CafienneTable<?>, E> CafienneJDBCConfig.QueryHelper<CT, E> QueryHelper(Query<CT, E, Seq> query) {
        return CafienneJDBCConfig.QueryHelper$(this, query);
    }

    @Override
    public <CTT extends CafienneJDBCConfig.CafienneTenantTable<?>, E> CafienneJDBCConfig.TenantQueryHelper<CTT, E> TenantQueryHelper(Query<CTT, E, Seq> query) {
        return CafienneJDBCConfig.TenantQueryHelper$(this, query);
    }

    @Override
    public MigrationSeq asSqlMigration(SqlAction<?, ?, ?> action) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, action);
    }

    @Override
    public MigrationSeq asSqlMigration(Seq<String> sql) {
        return CafienneJDBCConfig.asSqlMigration$((CafienneJDBCConfig)this, sql);
    }

    @Override
    public OffsetRecord createOffsetRecord(Offset offset) {
        return OffsetStorage.createOffsetRecord$(this, offset);
    }

    @Override
    public TableQuery<OffsetStoreTables.OffsetStoreTable> offsetQuery() {
        return this.offsetQuery;
    }

    @Override
    public void org$cafienne$infrastructure$jdbc$cqrs$JDBCOffsetStorage$_setter_$offsetQuery_$eq(TableQuery<OffsetStoreTables.OffsetStoreTable> x$1) {
        this.offsetQuery = x$1;
    }

    private JdbcBackend.DatabaseDef db$lzycompute() {
        JDBCTimerStore jDBCTimerStore = this;
        synchronized (jDBCTimerStore) {
            if ((byte)(this.bitmap$0 & 2) == 0) {
                this.db = CafienneJDBCConfig.db$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 2);
            }
        }
        return this.db;
    }

    @Override
    public JdbcBackend.DatabaseDef db() {
        return (byte)(this.bitmap$0 & 2) == 0 ? this.db$lzycompute() : this.db;
    }

    private boolean isSQLServer$lzycompute() {
        JDBCTimerStore jDBCTimerStore = this;
        synchronized (jDBCTimerStore) {
            if ((byte)(this.bitmap$0 & 4) == 0) {
                this.isSQLServer = CafienneJDBCConfig.isSQLServer$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 4);
            }
        }
        return this.isSQLServer;
    }

    @Override
    public boolean isSQLServer() {
        return (byte)(this.bitmap$0 & 4) == 0 ? this.isSQLServer$lzycompute() : this.isSQLServer;
    }

    private Dialect<? extends JdbcProfile> dialect$lzycompute() {
        JDBCTimerStore jDBCTimerStore = this;
        synchronized (jDBCTimerStore) {
            if ((byte)(this.bitmap$0 & 8) == 0) {
                this.dialect = CafienneJDBCConfig.dialect$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 8);
            }
        }
        return this.dialect;
    }

    @Override
    public Dialect<? extends JdbcProfile> dialect() {
        return (byte)(this.bitmap$0 & 8) == 0 ? this.dialect$lzycompute() : this.dialect;
    }

    @Override
    public String storageName() {
        return this.storageName;
    }

    private String description$lzycompute() {
        JDBCTimerStore jDBCTimerStore = this;
        synchronized (jDBCTimerStore) {
            if ((byte)(this.bitmap$0 & 0x10) == 0) {
                this.description = TimerStore.description$(this);
                this.bitmap$0 = (byte)(this.bitmap$0 | 0x10);
            }
        }
        return this.description;
    }

    @Override
    public String description() {
        return (byte)(this.bitmap$0 & 0x10) == 0 ? this.description$lzycompute() : this.description;
    }

    @Override
    public void org$cafienne$timerservice$persistence$TimerStore$_setter_$ec_$eq(ExecutionContext x$1) {
    }

    @Override
    public void org$cafienne$timerservice$persistence$TimerStore$_setter_$storageName_$eq(String x$1) {
        this.storageName = x$1;
    }

    private Logger logger$lzycompute() {
        JDBCTimerStore jDBCTimerStore = this;
        synchronized (jDBCTimerStore) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    private DatabaseConfig<JdbcProfile> dbConfig$lzycompute() {
        JDBCTimerStore jDBCTimerStore = this;
        synchronized (jDBCTimerStore) {
            if ((byte)(this.bitmap$0 & 1) == 0) {
                this.dbConfig = DatabaseConfig$.MODULE$.forConfig(Cafienne$.MODULE$.config().engine().timerService().store(), DatabaseConfig$.MODULE$.forConfig$default$2(), DatabaseConfig$.MODULE$.forConfig$default$3(), ClassTag$.MODULE$.apply(JdbcProfile.class));
                this.bitmap$0 = (byte)(this.bitmap$0 | 1);
            }
        }
        return this.dbConfig;
    }

    @Override
    public DatabaseConfig<JdbcProfile> dbConfig() {
        return (byte)(this.bitmap$0 & 1) == 0 ? this.dbConfig$lzycompute() : this.dbConfig;
    }

    @Override
    public ExecutionContext ec() {
        return this.ec;
    }

    @Override
    public Future<Seq<Timer>> getTimers(Instant window) {
        Query query = TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TimerServiceTables.TimerServiceTable(this, (Tag)tag)).filter((Function1 & Serializable)x$1 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$1.moment(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())).$less$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)window, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().instantColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition());
        return this.db().run((DBIOAction)((JdbcActionComponent.StreamingQueryActionExtensionMethodsImpl)((JdbcProfile)this.dbConfig().profile()).api().streamableQueryActionExtensionMethods(query.distinct())).result()).map((Function1 & Serializable)records -> (Seq)records.map((Function1 & Serializable)record -> new Timer(record.caseInstanceId(), record.timerId(), record.moment(), record.user())), this.ec());
    }

    @Override
    public Future<Done> storeTimer(Timer job, Option<Offset> offset) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Storing JDBC timer " + job.timerId() + " for timestamp " + job.moment());
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        TimerServiceRecord record = new TimerServiceRecord(job.timerId(), job.caseInstanceId(), job.moment(), "", job.userId());
        return this.commit(offset, (DBIOAction<Object, NoStream, Effect.All>)((JdbcActionComponent.SimpleInsertActionComposer)((JdbcProfile)this.dbConfig().profile()).api().queryInsertActionExtensionMethods((Query)TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TimerServiceTables.TimerServiceTable(this, (Tag)tag)))).insertOrUpdate((Object)record));
    }

    @Override
    public Future<Done> removeTimer(String timerId, Option<Offset> offset) {
        BoxedUnit boxedUnit;
        if (this.logger().underlying().isDebugEnabled()) {
            this.logger().underlying().debug("Removing timer " + timerId);
            boxedUnit = BoxedUnit.UNIT;
        } else {
            boxedUnit = BoxedUnit.UNIT;
        }
        return this.commit(offset, (DBIOAction<Object, NoStream, Effect.All>)((JdbcProfile)this.dbConfig().profile()).api().queryDeleteActionExtensionMethods(TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TimerServiceTables.TimerServiceTable(this, (Tag)tag)).filter((Function1 & Serializable)x$2 -> new BaseColumnExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().columnExtensionMethods(x$2.timerId(), (BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())).$eq$eq$eq((Rep)((JdbcProfile)this.dbConfig().profile()).api().valueToConstColumn((Object)timerId, (TypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType()), OptionMapper2$.MODULE$.getOptionMapper2TT((BaseTypedType)((JdbcProfile)this.dbConfig().profile()).api().stringColumnType())), CanBeQueryCondition$.MODULE$.BooleanColumnCanBeQueryCondition())).delete());
    }

    private Future<Done> commit(Option<Offset> offset2, DBIOAction<Object, NoStream, Effect.All> action) {
        Option offsetUpdate = offset2.map((Function1 & Serializable)offset -> ((JdbcActionComponent.SimpleInsertActionComposer)((JdbcProfile)this.dbConfig().profile()).api().queryInsertActionExtensionMethods((Query)TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new OffsetStoreTables.OffsetStoreTable(this, (Tag)tag)))).insertOrUpdate((Object)OffsetRecord$.MODULE$.apply(this.storageName(), (Offset)offset)));
        Seq updates = (Seq)offsetUpdate.fold((Function0 & Serializable)() -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{action})), (Function1 & Serializable)o -> (Seq)package$.MODULE$.Seq().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new DBIOAction[]{action, o})));
        return this.db().run(((JdbcProfile)this.dbConfig().profile()).api().jdbcActionExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().DBIO().sequence((IterableOnce)updates, Seq$.MODULE$.iterableFactory())).transactionally()).map((Function1 & Serializable)x$3 -> Done$.MODULE$, this.ec());
    }

    @Override
    public void importTimers(Seq<Timer> list) {
        Seq tx = (Seq)((IterableOps)list.map((Function1 & Serializable)job -> new TimerServiceRecord(job.timerId(), job.caseInstanceId(), job.moment(), "", job.userId()))).map((Function1 & Serializable)record -> ((JdbcActionComponent.SimpleInsertActionComposer)((JdbcProfile)this.dbConfig().profile()).api().queryInsertActionExtensionMethods((Query)TableQuery$.MODULE$.apply((Function1 & Serializable)tag -> new TimerServiceTables.TimerServiceTable(this, (Tag)tag)))).insertOrUpdate(record));
        Await$.MODULE$.result((Awaitable)this.db().run(((JdbcProfile)this.dbConfig().profile()).api().jdbcActionExtensionMethods(((JdbcProfile)this.dbConfig().profile()).api().DBIO().sequence((IterableOnce)tx, Seq$.MODULE$.iterableFactory())).transactionally()), (Duration)new package.DurationInt(scala.concurrent.duration.package$.MODULE$.DurationInt(30)).seconds());
    }

    public JDBCTimerStore() {
        LazyLogging.$init$((LazyLogging)this);
        TimerStore.$init$(this);
        OffsetStorage.$init$(this);
        CafienneJDBCConfig.$init$(this);
        OffsetStoreTables.$init$(this);
        JDBCOffsetStorage.$init$(this);
        TimerServiceTables.$init$(this);
        this.ec = this.db().ioExecutionContext();
        Statics.releaseFence();
    }
}

