/*
 * Copyright 2014 - 2019 Cafienne B.V.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
package org.cafienne.consentgroup.actorapi.event;

import com.fasterxml.jackson.core.JsonGenerator;
import org.cafienne.actormodel.event.BaseModelEvent;
import org.cafienne.consentgroup.ConsentGroupActor;
import org.cafienne.json.ValueMap;

import java.io.IOException;

/**
 * ConsentGroupEvents are generated by the {@link ConsentGroupActor}.
 */
public abstract class ConsentGroupBaseEvent extends BaseModelEvent<ConsentGroupActor> implements ConsentGroupEvent {
    protected ConsentGroupBaseEvent(ConsentGroupActor group) {
        super(group);
    }

    protected ConsentGroupBaseEvent(ValueMap json) {
        super(json);
    }

    protected void writeConsentGroupEvent(JsonGenerator generator) throws IOException {
        super.writeModelEvent(generator);
    }
}
