package org.cafienne.service.akkahttp.cases.model

import io.swagger.v3.oas.annotations.media.Schema
import org.cafienne.infrastructure.akkahttp.EntityReader.{EntityReader, entityReader}

import scala.annotation.meta.field

object CasePlanAPI {
  implicit val discretionaryItemReader: EntityReader[PlanDiscretionaryItem] = entityReader[PlanDiscretionaryItem]
  implicit val assigneeReader: EntityReader[Assignee] = entityReader[Assignee]

  @Schema(description = "Add a discretionary item to the plan")
  case class PlanDiscretionaryItem(
                                    @(Schema@field)(
                                      description = "Name of the item to be added",
                                      required = true,
                                      example = "Task such and so",
                                      implementation = classOf[String])
                                    name: String,
                                    @(Schema@field)(
                                      description = "Identifier of the item in the case definition",
                                      required = true,
                                      example = "Identifier of the item in the case definition",
                                      implementation = classOf[String])
                                    definitionId: String,
                                    @(Schema@field)(
                                      description = "Identifier of the parent stage or human task to which the item belongs",
                                      required = true,
                                      example = "guid or so",
                                      implementation = classOf[String])
                                    parentId: String,
                                    @(Schema@field)(
                                      description = "Optional identifier for the newly added plan item. If omitted, it will be generated by the server",
                                      required = false,
                                      example = "Task such and so",
                                      implementation = classOf[String])
                                    planItemId: Option[String]
                                  )

  @Schema(description = "Assign a task to someone")
  case class Assignee(@(Schema @field)(description = "Assignee", required = true, implementation = classOf[String]) assignee: String)
}
