/*
 * Copyright 2014 - 2019 Cafienne B.V.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
package org.cafienne.tenant.actorapi.event;

import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.tenant.TenantActor;
import org.cafienne.tenant.actorapi.TenantMessage;

import java.util.Set;

/**
 * TenantEvents are generated by the {@link TenantActor}.
 */
public interface TenantEvent extends ModelEvent, TenantMessage {
    String TAG = "cafienne:tenant";

    Set<String> tags = Set.of(ModelEvent.TAG, TenantEvent.TAG);

    @Override
    default Set<String> tags() {
        return tags;
    }
}
