/*
 * Copyright 2014 - 2019 Cafienne B.V.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */
package org.cafienne.tenant.actorapi.event.platform;

import com.fasterxml.jackson.core.JsonGenerator;
import org.cafienne.json.ValueMap;
import org.cafienne.tenant.TenantActor;
import org.cafienne.tenant.actorapi.event.TenantBaseEvent;

import java.io.IOException;

/**
 * Platform events are generated by platform owners that administer the tenants in {@link TenantActor}.
 */
public abstract class PlatformBaseEvent extends TenantBaseEvent implements PlatformEvent {
    protected PlatformBaseEvent(TenantActor tenant) {
        super(tenant);
    }

    protected PlatformBaseEvent(ValueMap json) {
        super(json);
    }

    public String tenantName() {
        return getActorId();
    }

    @Override
    public void write(JsonGenerator generator) throws IOException {
        super.writeTenantEvent(generator);
    }
}
