/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel;

import akka.persistence.journal.Tagged;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.event.CommitEvent;
import org.cafienne.actormodel.event.DebugEvent;
import org.cafienne.actormodel.event.EngineVersionChanged;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.message.IncomingActorMessage;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.actormodel.response.EngineChokedFailure;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.cmmn.instance.debug.DebugInfoAppender;
import org.cafienne.infrastructure.Cafienne;
import org.cafienne.infrastructure.CafienneVersion;
import org.cafienne.infrastructure.enginedeveloper.EngineDeveloperConsole;
import org.cafienne.json.Value;
import org.cafienne.system.health.HealthMonitor;
import org.slf4j.Logger;

class StagingArea {
    private final ModelActor actor;
    private static final int avgNumEvents = 30;
    private final List<ModelEvent> events = new ArrayList<ModelEvent>(30);
    private DebugEvent debugEvent;
    private final IncomingActorMessage message;
    private ModelResponse response = null;

    StagingArea(ModelActor modelActor, IncomingActorMessage incomingActorMessage) {
        this.actor = modelActor;
        this.message = incomingActorMessage;
        this.checkEngineVersion();
    }

    private void checkEngineVersion() {
        CafienneVersion cafienneVersion = Cafienne.version();
        CafienneVersion cafienneVersion2 = this.actor.getEngineVersion();
        if (cafienneVersion2 != null && cafienneVersion.differs(this.actor.getEngineVersion())) {
            this.actor.getLogger().info(this.actor + " changed engine version from\n" + this.actor.getEngineVersion() + " to\n" + cafienneVersion);
            this.addEvent(new EngineVersionChanged(this.actor, cafienneVersion));
        }
    }

    void addEvent(ModelEvent modelEvent) {
        this.events.add(modelEvent);
        this.addDebugInfo(this.actor.getLogger(), () -> "Updating actor state for new event " + modelEvent.getDescription(), new Object[0]);
        modelEvent.updateActorState(this.actor);
    }

    private Logger getLogger() {
        return this.actor.getLogger();
    }

    void store() {
        if (this.hasFailures()) {
            this.replyAndPersistDebugEvent(this.response);
            if (this.hasStatefulEvents()) {
                Throwable throwable = ((CommandFailure)this.response).internalException();
                this.actor.addDebugInfo(() -> {
                    StringBuilder stringBuilder = new StringBuilder("\n------------------------ ABORTING PERSISTENCE OF " + this.events.size() + " EVENTS IN " + this.actor);
                    this.events.forEach(modelEvent -> stringBuilder.append("\n\t").append(modelEvent.getDescription()));
                    return stringBuilder + "\n";
                }, throwable);
                this.actor.failedWithInvalidState(this.message, throwable);
            }
        } else if (this.hasStatefulEvents()) {
            if (this.needsCommitEvent()) {
                this.actor.completeTransaction(this.message);
            }
            this.persistEventsAndThenReply(this.response);
        } else {
            this.replyAndPersistDebugEvent(this.response);
        }
    }

    private void replyAndPersistDebugEvent(ModelResponse modelResponse) {
        this.actor.reply(modelResponse);
        if (this.hasDebugEvent()) {
            this.actor.persistAsync(this.tag(this.debugEvent), object -> {});
        }
    }

    private Object tag(ModelEvent modelEvent) {
        return new Tagged((Object)modelEvent, modelEvent.tags());
    }

    private void persistEventsAndThenReply(ModelResponse modelResponse) {
        Object object;
        if (this.getLogger().isDebugEnabled() || EngineDeveloperConsole.enabled()) {
            object = new StringBuilder("\n------------------------ PERSISTING " + this.events.size() + " EVENTS IN " + this.actor);
            this.events.forEach(arg_0 -> StagingArea.lambda$persistEventsAndThenReply$4((StringBuilder)object, arg_0));
            this.getLogger().debug((StringBuilder)object + "\n");
            EngineDeveloperConsole.debugIndentedConsoleLogging((StringBuilder)object + "\n");
        }
        if (this.hasDebugEvent()) {
            this.events.add(0, this.debugEvent);
        }
        object = this.events.stream().map(this::tag).collect(Collectors.toList());
        Object e = object.get(object.size() - 1);
        this.actor.persistAll((Iterable)object, object2 -> {
            HealthMonitor.writeJournal().isOK();
            if (this.getLogger().isDebugEnabled()) {
                if (object2 instanceof Tagged) {
                    Object object3 = ((Tagged)object2).payload();
                    this.getLogger().debug(this.actor + " - persisted event [" + this.actor.lastSequenceNr() + "] of type " + object3.getClass().getName());
                } else {
                    this.getLogger().debug(this.actor + " - persisted event [" + this.actor.lastSequenceNr() + "] of type " + object2.getClass().getName());
                }
            }
            if (object2 == e) {
                this.actor.reply(modelResponse);
            }
        });
    }

    void reportFailure(ModelCommand modelCommand, Throwable throwable, String string) {
        this.reportFailure(throwable, new CommandFailure(modelCommand, throwable), string);
    }

    void reportFailure(Throwable throwable, CommandFailure commandFailure, String string) {
        this.actor.addDebugInfo(() -> "", throwable, string);
        this.response = commandFailure;
    }

    void setResponse(ModelResponse modelResponse) {
        this.response = modelResponse;
    }

    void handlePersistFailure(Throwable throwable, Object object, long l) {
        if (this.message.isCommand()) {
            this.actor.reply(new EngineChokedFailure(this.message.asCommand(), new Exception("Handling the request resulted in a system failure. Check the server logs for more information.")));
        }
    }

    private DebugEvent getDebugEvent() {
        if (this.debugEvent == null) {
            this.debugEvent = new DebugEvent(this.actor);
        }
        return this.debugEvent;
    }

    private boolean hasDebugEvent() {
        return this.debugEvent != null && this.actor.debugMode() && !this.actor.recoveryRunning();
    }

    private boolean hasFailures() {
        return this.response instanceof CommandFailure;
    }

    private boolean hasStatefulEvents() {
        return this.events.size() > 0;
    }

    private boolean needsCommitEvent() {
        return this.events.size() > 0 && !(this.events.get(this.events.size() - 1) instanceof CommitEvent);
    }

    void addDebugInfo(Logger logger, DebugInfoAppender debugInfoAppender, Object ... objectArray) {
        if (this.logDebugMessages(logger)) {
            Object object = debugInfoAppender.info();
            if (objectArray.length == 0 || this.needsSeparateLine(objectArray[0])) {
                this.logObject(logger, object);
                this.logObjects(logger, objectArray);
            } else {
                objectArray[0] = String.valueOf(object) + objectArray[0];
                this.logObjects(logger, objectArray);
            }
        }
    }

    private boolean needsSeparateLine(Object object) {
        return object instanceof Throwable || object instanceof Value && !((Value)object).isPrimitive();
    }

    private void logObjects(Logger logger, Object ... objectArray) {
        for (Object object : objectArray) {
            this.logObject(logger, object);
        }
    }

    private void logObject(Logger logger, Object object) {
        if (object instanceof Throwable) {
            this.logException(logger, (Throwable)object);
        } else if (object instanceof Value) {
            this.logJSON(logger, (Value)object);
        } else {
            this.logString(logger, String.valueOf(object));
        }
    }

    private void logString(Logger logger, String string) {
        if (string.isBlank()) {
            return;
        }
        logger.debug(string);
        EngineDeveloperConsole.debugIndentedConsoleLogging(string);
        this.getDebugEvent().addMessage(string);
    }

    private void logJSON(Logger logger, Value<?> value) {
        logger.debug(value.toString());
        EngineDeveloperConsole.debugIndentedConsoleLogging(value);
        this.getDebugEvent().addMessage(value);
    }

    private void logException(Logger logger, Throwable throwable) {
        logger.debug(throwable.getMessage(), throwable);
        EngineDeveloperConsole.debugIndentedConsoleLogging(throwable);
        this.getDebugEvent().addMessage(throwable);
    }

    private boolean logDebugMessages(Logger logger) {
        return EngineDeveloperConsole.enabled() || logger.isDebugEnabled() || this.actor.debugMode();
    }

    private static /* synthetic */ void lambda$persistEventsAndThenReply$4(StringBuilder stringBuilder, ModelEvent modelEvent) {
        stringBuilder.append("\n\t").append(modelEvent);
    }
}

