/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.command;

import akka.actor.ActorPath;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.PrettyPrinter;
import com.fasterxml.jackson.core.util.DefaultPrettyPrinter;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.CafienneJson;
import org.cafienne.json.JSONParseFailure;
import org.cafienne.json.JSONReader;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.cafienne.util.Guid;

public abstract class BaseModelCommand<T extends ModelActor, U extends UserIdentity>
implements ModelCommand {
    protected final String msgId;
    public final String actorId;
    protected transient T actor;
    private final U user;

    protected BaseModelCommand(U u, String string) {
        if (string == null) {
            throw new InvalidCommandException("Actor id cannot be null");
        }
        try {
            ActorPath.validatePathElement((String)string);
        }
        catch (Throwable throwable) {
            throw new InvalidCommandException("Invalid actor path " + string, throwable);
        }
        if (u == null || u.id() == null || u.id().trim().isEmpty()) {
            throw new InvalidCommandException("Tenant user cannot be null");
        }
        this.msgId = new Guid().toString();
        this.user = u;
        this.actorId = string;
    }

    protected BaseModelCommand(ValueMap valueMap) {
        this.msgId = valueMap.readString((Object)Fields.messageId, new String[0]);
        this.actorId = valueMap.readString((Object)Fields.actorId, new String[0]);
        this.user = this.readUser(valueMap.with((Object)Fields.user));
    }

    protected abstract U readUser(ValueMap var1);

    @Override
    public final void setActor(ModelActor modelActor) {
        this.actor = modelActor;
    }

    @Override
    public final void validateCommand(ModelActor modelActor) {
        this.validate(modelActor);
    }

    @Override
    public final ModelResponse processCommand(ModelActor modelActor) {
        return this.process(modelActor);
    }

    public T getActor() {
        return this.actor;
    }

    public final U getUser() {
        return this.user;
    }

    @Override
    public final String getActorId() {
        return this.actorId;
    }

    @Override
    public String getMessageId() {
        return this.msgId;
    }

    public abstract void validate(T var1) throws InvalidCommandException;

    public abstract ModelResponse process(T var1);

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        this.writeModelCommand(jsonGenerator);
    }

    protected void writeModelCommand(JsonGenerator jsonGenerator) throws IOException {
        this.writeField(jsonGenerator, (Object)Fields.messageId, this.getMessageId());
        this.writeField(jsonGenerator, (Object)Fields.actorId, this.getActorId());
        this.writeField(jsonGenerator, (Object)Fields.user, (CafienneJson)this.user);
    }

    @Override
    public String getCommandDescription() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return "Command [" + this.getCommandDescription() + "]" + super.toString();
    }

    @Override
    public Value<?> toJson() {
        JsonFactory jsonFactory = new JsonFactory();
        StringWriter stringWriter = new StringWriter();
        try {
            JsonGenerator jsonGenerator = jsonFactory.createGenerator((Writer)stringWriter);
            jsonGenerator.setPrettyPrinter((PrettyPrinter)new DefaultPrettyPrinter());
            this.writeThisObject(jsonGenerator);
            jsonGenerator.close();
            return JSONReader.parse(stringWriter.toString());
        }
        catch (IOException | JSONParseFailure exception) {
            return new ValueMap("message", "Could not make JSON out of command " + this.getClass().getName(), "exception", Value.convertThrowable(exception));
        }
    }
}

