/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.time.Instant;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.actormodel.identity.UserIdentity;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class BaseModelEvent<M extends ModelActor>
implements ModelEvent {
    private final ValueMap json;
    private final String actorId;
    public final String tenant;
    private final UserIdentity user;
    private final Instant timestamp;

    protected BaseModelEvent(M m) {
        this.json = new ValueMap();
        this.actorId = ((ModelActor)((Object)m)).getId();
        this.tenant = ((ModelActor)((Object)m)).getTenant();
        this.user = ((ModelActor)((Object)m)).getCurrentUser();
        this.timestamp = ((ModelActor)((Object)m)).getTransactionTimestamp();
    }

    protected BaseModelEvent(ValueMap valueMap) {
        this.json = valueMap;
        ValueMap valueMap2 = valueMap.with((Object)Fields.modelEvent);
        this.actorId = valueMap2.readString((Object)Fields.actorId, new String[0]);
        this.tenant = valueMap2.readString((Object)Fields.tenant, new String[0]);
        this.timestamp = valueMap2.readInstant((Object)Fields.timestamp);
        this.user = valueMap2.readObject((Object)Fields.user, UserIdentity::deserialize);
    }

    @Override
    public String tenant() {
        return this.tenant;
    }

    @Override
    public final ValueMap rawJson() {
        return this.json;
    }

    @Override
    public final String getActorId() {
        return this.actorId;
    }

    @Override
    public final UserIdentity getUser() {
        return this.user;
    }

    @Override
    public final Instant getTimestamp() {
        return this.timestamp;
    }

    public abstract void updateState(M var1);

    @Override
    public final void updateActorState(ModelActor modelActor) {
        this.updateState(modelActor);
    }

    protected void writeModelEvent(JsonGenerator jsonGenerator) throws IOException {
        jsonGenerator.writeFieldName(Fields.modelEvent.toString());
        jsonGenerator.writeStartObject();
        this.writeField(jsonGenerator, (Object)Fields.actorId, this.getActorId());
        this.writeField(jsonGenerator, (Object)Fields.tenant, this.tenant);
        this.writeField(jsonGenerator, (Object)Fields.timestamp, this.timestamp);
        this.writeField(jsonGenerator, (Object)Fields.user, this.user);
        jsonGenerator.writeEndObject();
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName();
    }

    public String toString() {
        return this.getDescription();
    }
}

