/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.actormodel.event;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.event.BaseModelEvent;
import org.cafienne.infrastructure.CafienneVersion;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class EngineVersionChanged
extends BaseModelEvent<ModelActor> {
    private final CafienneVersion version;

    public EngineVersionChanged(ModelActor modelActor, CafienneVersion cafienneVersion) {
        super(modelActor);
        this.version = cafienneVersion;
    }

    public EngineVersionChanged(ValueMap valueMap) {
        super(valueMap);
        this.version = valueMap.readObject((Object)Fields.version, CafienneVersion::new);
    }

    @Override
    public void updateState(ModelActor modelActor) {
        modelActor.setEngineVersion(this.version);
    }

    @Override
    public String getDescription() {
        return super.getDescription() + " to " + this.version.description();
    }

    public CafienneVersion version() {
        return this.version;
    }

    @Override
    public String toString() {
        return "Engine version changed to " + this.version;
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeModelEvent(jsonGenerator);
        super.writeField(jsonGenerator, (Object)Fields.version, this.version.json());
    }
}

