/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.authentication;

import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.RemoteKeySourceException;
import com.nimbusds.jose.jwk.source.JWKSource;
import com.nimbusds.jose.proc.BadJOSEException;
import com.nimbusds.jose.proc.JWSKeySelector;
import com.nimbusds.jose.proc.JWSVerificationKeySelector;
import com.nimbusds.jose.proc.SecurityContext;
import com.nimbusds.jwt.JWTClaimsSet;
import com.nimbusds.jwt.proc.BadJWTException;
import com.nimbusds.jwt.proc.ConfigurableJWTProcessor;
import com.nimbusds.jwt.proc.DefaultJWTClaimsVerifier;
import com.nimbusds.jwt.proc.DefaultJWTProcessor;
import com.nimbusds.jwt.proc.JWTClaimsSetVerifier;
import com.typesafe.scalalogging.LazyLogging;
import com.typesafe.scalalogging.Logger;
import java.io.Serializable;
import java.text.ParseException;
import java.util.Arrays;
import java.util.HashSet;
import org.cafienne.authentication.AuthenticatedUser;
import org.cafienne.authentication.CannotReachIDPException;
import org.cafienne.authentication.InvalidIssuerException;
import org.cafienne.authentication.MissingClaimsException;
import org.cafienne.authentication.MissingTokenException$;
import org.cafienne.authentication.TokenVerificationException;
import org.cafienne.authentication.TokenVerificationException$;
import org.cafienne.authentication.TokenVerifier;
import org.cafienne.infrastructure.Cafienne$;
import org.cafienne.system.health.HealthMonitor$;
import scala.Function0;
import scala.Function1;
import scala.MatchError;
import scala.None$;
import scala.Some;
import scala.concurrent.ExecutionContext;
import scala.concurrent.Future;
import scala.concurrent.Future$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;

@ScalaSignature(bytes="\u0006\u0005]4A\u0001D\u0007\u0001)!AA\u0006\u0001B\u0001B\u0003%Q\u0006\u0003\u0005@\u0001\t\u0005\t\u0015!\u0003A\u0011!Y\u0005A!A!\u0002\u0017a\u0005\"\u0002*\u0001\t\u0003\u0019\u0006bB-\u0001\u0005\u0004%\tA\u0017\u0005\u0007E\u0002\u0001\u000b\u0011B.\t\u000f\r\u0004!\u0019!C\u0001I\"1\u0011\u000e\u0001Q\u0001\n\u0015DqA\u001b\u0001C\u0002\u0013\u00051\u000e\u0003\u0004p\u0001\u0001\u0006I\u0001\u001c\u0005\u0006a\u0002!\t%\u001d\u0002\u0011\u0015^$Hk\\6f]Z+'/\u001b4jKJT!AD\b\u0002\u001d\u0005,H\u000f[3oi&\u001c\u0017\r^5p]*\u0011\u0001#E\u0001\tG\u00064\u0017.\u001a8oK*\t!#A\u0002pe\u001e\u001c\u0001a\u0005\u0003\u0001+m\u0011\u0003C\u0001\f\u001a\u001b\u00059\"\"\u0001\r\u0002\u000bM\u001c\u0017\r\\1\n\u0005i9\"AB!osJ+g\rE\u0002\u001d;}i\u0011!D\u0005\u0003=5\u0011Q\u0002V8lK:4VM]5gS\u0016\u0014\bC\u0001\u000f!\u0013\t\tSBA\tBkRDWM\u001c;jG\u0006$X\rZ+tKJ\u0004\"a\t\u0016\u000e\u0003\u0011R!!\n\u0014\u0002\u0019M\u001c\u0017\r\\1m_\u001e<\u0017N\\4\u000b\u0005\u001dB\u0013\u0001\u0003;za\u0016\u001c\u0018MZ3\u000b\u0003%\n1aY8n\u0013\tYCEA\u0006MCjLHj\\4hS:<\u0017!C6fsN{WO]2f!\rqs'O\u0007\u0002_)\u0011\u0001'M\u0001\u0007g>,(oY3\u000b\u0005I\u001a\u0014a\u00016xW*\u0011A'N\u0001\u0005U>\u001cXM\u0003\u00027Q\u0005Aa.[7ckN$7/\u0003\u00029_\tI!jV&T_V\u00148-\u001a\t\u0003uuj\u0011a\u000f\u0006\u0003yM\nA\u0001\u001d:pG&\u0011ah\u000f\u0002\u0010'\u0016\u001cWO]5us\u000e{g\u000e^3yi\u00061\u0011n]:vKJ\u0004\"!\u0011%\u000f\u0005\t3\u0005CA\"\u0018\u001b\u0005!%BA#\u0014\u0003\u0019a$o\\8u}%\u0011qiF\u0001\u0007!J,G-\u001a4\n\u0005%S%AB*ue&twM\u0003\u0002H/\u0005\u0011Qm\u0019\t\u0003\u001bBk\u0011A\u0014\u0006\u0003\u001f^\t!bY8oGV\u0014(/\u001a8u\u0013\t\tfJ\u0001\tFq\u0016\u001cW\u000f^5p]\u000e{g\u000e^3yi\u00061A(\u001b8jiz\"2\u0001V,Y)\t)f\u000b\u0005\u0002\u001d\u0001!)1\n\u0002a\u0002\u0019\")A\u0006\u0002a\u0001[!)q\b\u0002a\u0001\u0001\u0006a!n\u001e;Qe>\u001cWm]:peV\t1\fE\u0002]Afj\u0011!\u0018\u0006\u0003yyS!aX\u001b\u0002\u0007)<H/\u0003\u0002b;\nA2i\u001c8gS\u001e,(/\u00192mK*;F\u000b\u0015:pG\u0016\u001c8o\u001c:\u0002\u001b)<H\u000f\u0015:pG\u0016\u001c8o\u001c:!\u00039)\u0007\u0010]3di\u0016$'jV*BY\u001e,\u0012!\u001a\t\u0003M\u001el\u0011aM\u0005\u0003QN\u0012ABS,T\u00032<wN]5uQ6\fq\"\u001a=qK\u000e$X\r\u001a&X'\u0006cw\rI\u0001\fW\u0016L8+\u001a7fGR|'/F\u0001m!\rQT.O\u0005\u0003]n\u0012aBS,T\u0017\u0016L8+\u001a7fGR|'/\u0001\u0007lKf\u001cV\r\\3di>\u0014\b%A\u0006wKJLg-\u001f+pW\u0016tGC\u0001:v!\ri5oH\u0005\u0003i:\u0013aAR;ukJ,\u0007\"\u0002<\f\u0001\u0004\u0001\u0015!\u0002;pW\u0016t\u0007")
public class JwtTokenVerifier
implements TokenVerifier<AuthenticatedUser>,
LazyLogging {
    private final ExecutionContext ec;
    private final ConfigurableJWTProcessor<SecurityContext> jwtProcessor;
    private final JWSAlgorithm expectedJWSAlg;
    private final JWSKeySelector<SecurityContext> keySelector;
    private transient Logger logger;
    private volatile transient boolean bitmap$trans$0;

    private Logger logger$lzycompute() {
        JwtTokenVerifier jwtTokenVerifier = this;
        synchronized (jwtTokenVerifier) {
            if (!this.bitmap$trans$0) {
                this.logger = LazyLogging.logger$((LazyLogging)this);
                this.bitmap$trans$0 = true;
            }
        }
        return this.logger;
    }

    public Logger logger() {
        return !this.bitmap$trans$0 ? this.logger$lzycompute() : this.logger;
    }

    public ConfigurableJWTProcessor<SecurityContext> jwtProcessor() {
        return this.jwtProcessor;
    }

    public JWSAlgorithm expectedJWSAlg() {
        return this.expectedJWSAlg;
    }

    public JWSKeySelector<SecurityContext> keySelector() {
        return this.keySelector;
    }

    @Override
    public Future<AuthenticatedUser> verifyToken(String token) {
        return Future$.MODULE$.apply((Function0 & Serializable)() -> {
            AuthenticatedUser authenticatedUser;
            None$ claimsSet = None$.MODULE$;
            if (token.isEmpty()) {
                throw MissingTokenException$.MODULE$;
            }
            try {
                SecurityContext ctx = null;
                claimsSet = new Some((Object)this.jwtProcessor().process(token, ctx));
                authenticatedUser = (AuthenticatedUser)claimsSet.fold((Function0 & Serializable)() -> {
                    throw new TokenVerificationException("Unable to create claimSet for " + token);
                }, (Function1 & Serializable)cS -> {
                    HealthMonitor$.MODULE$.idp().isOK();
                    return new AuthenticatedUser(token, (JWTClaimsSet)cS);
                });
            }
            catch (RemoteKeySourceException rp) {
                BoxedUnit boxedUnit;
                if (this.logger().underlying().isErrorEnabled()) {
                    this.logger().underlying().error("Failure in contacting IDP. Check IDP configuration settings of the case engine.", (Throwable)rp);
                    boxedUnit = BoxedUnit.UNIT;
                } else {
                    boxedUnit = BoxedUnit.UNIT;
                }
                CannotReachIDPException failure = new CannotReachIDPException("Cannot reach the IDP to validate credentials", rp);
                HealthMonitor$.MODULE$.idp().hasFailed(failure);
                throw failure;
            }
            catch (Throwable other) {
                HealthMonitor$.MODULE$.idp().isOK();
                Throwable throwable = other;
                if (throwable instanceof BadJWTException) {
                    BadJWTException badJWTException = (BadJWTException)throwable;
                    String exceptionMessage = badJWTException.getMessage();
                    String missingClaimsMsg = "JWT missing required claims";
                    String invalidIssuerMsg = "JWT \"iss\" claim doesn't match expected value: ";
                    if (badJWTException.getCause() instanceof ParseException) {
                        throw new TokenVerificationException("Token parse failure: " + badJWTException.getCause().getLocalizedMessage());
                    }
                    if (exceptionMessage.contains(missingClaimsMsg)) {
                        throw new MissingClaimsException(exceptionMessage.replace(missingClaimsMsg, "JWT token misses claims"));
                    }
                    if (exceptionMessage.contains(invalidIssuerMsg)) {
                        String invalidIssuer = exceptionMessage.replace(invalidIssuerMsg, "");
                        throw new InvalidIssuerException("JWT token has invalid issuer '" + invalidIssuer + "'. Issuers supported: " + Cafienne$.MODULE$.config().OIDC().issuer());
                    }
                    throw TokenVerificationException$.MODULE$.apply("Invalid token: " + badJWTException.getLocalizedMessage());
                }
                if (throwable instanceof BadJOSEException) {
                    BoxedUnit boxedUnit;
                    BadJOSEException badJOSEException = (BadJOSEException)throwable;
                    if (this.logger().underlying().isDebugEnabled()) {
                        this.logger().underlying().debug("Encountered JWT issues", (Throwable)badJOSEException);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw TokenVerificationException$.MODULE$.apply("Token cannot be verified: " + badJOSEException.getLocalizedMessage());
                }
                if (throwable instanceof ParseException) {
                    ParseException parseException = (ParseException)throwable;
                    throw TokenVerificationException$.MODULE$.apply("Token parse failure: " + parseException.getLocalizedMessage());
                }
                if (throwable != null) {
                    BoxedUnit boxedUnit;
                    Throwable throwable2 = throwable;
                    if (this.logger().underlying().isErrorEnabled()) {
                        this.logger().underlying().error("Unexpected or unforeseen exception during token verification; throwing it further", throwable2);
                        boxedUnit = BoxedUnit.UNIT;
                    } else {
                        boxedUnit = BoxedUnit.UNIT;
                    }
                    throw new TokenVerificationException("Token verification failure of type " + throwable2.getClass().getSimpleName(), throwable2);
                }
                throw new MatchError((Object)throwable);
            }
            return authenticatedUser;
        }, this.ec);
    }

    public JwtTokenVerifier(JWKSource<SecurityContext> keySource, String issuer, ExecutionContext ec) {
        this.ec = ec;
        LazyLogging.$init$((LazyLogging)this);
        this.jwtProcessor = new DefaultJWTProcessor();
        this.expectedJWSAlg = JWSAlgorithm.RS256;
        this.keySelector = new JWSVerificationKeySelector(this.expectedJWSAlg(), keySource);
        this.jwtProcessor().setJWSKeySelector(this.keySelector());
        this.jwtProcessor().setJWTClaimsSetVerifier((JWTClaimsSetVerifier)new DefaultJWTClaimsVerifier(new JWTClaimsSet.Builder().issuer(issuer).build(), new HashSet<Object>(Arrays.asList((Object[])new String[]{"sub", "exp"}))));
    }
}

