/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.plan;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import org.cafienne.actormodel.exception.CommandException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.response.CaseNotModifiedResponse;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class MakePlanItemTransition
extends CaseCommand {
    private final String identifier;
    private final Transition transition;

    public MakePlanItemTransition(CaseUserIdentity caseUserIdentity, String string, String string2, Transition transition) {
        super(caseUserIdentity, string);
        this.identifier = string2;
        this.transition = transition;
    }

    public MakePlanItemTransition(ValueMap valueMap) {
        super(valueMap);
        this.identifier = valueMap.readString((Object)Fields.identifier, new String[0]);
        this.transition = valueMap.readEnum((Object)Fields.transition, Transition.class);
    }

    public String getIdentifier() {
        return this.identifier;
    }

    public Transition getTransition() {
        return this.transition;
    }

    @Override
    public String toString() {
        return "Transition " + this.identifier + "." + this.transition;
    }

    @Override
    public void validate(Case case_) throws InvalidCommandException {
        super.validate(case_);
        this.validateTransition(case_);
    }

    protected void validateTransition(Case case_) {
        this.getTargetPlanItems(case_).forEach(planItem -> planItem.validateTransition(this.transition));
    }

    private List<PlanItem<?>> getTargetPlanItems(Case case_) {
        ArrayList arrayList = new ArrayList();
        if (this.identifier != null && !this.identifier.trim().isEmpty()) {
            Object t = case_.getPlanItemById(this.identifier);
            if (t != null) {
                arrayList.add((PlanItem<?>)t);
            } else {
                case_.getPlanItems().stream().filter(planItem -> planItem.getName().equals(this.identifier) && planItem.hasActiveParent()).forEach(arrayList::add);
            }
        }
        if (arrayList.isEmpty()) {
            throw new CommandException("There is no plan item with identifier '" + this.identifier + "' in case " + case_.getId());
        }
        return arrayList;
    }

    public CaseResponse process(Case case_) {
        boolean bl = false;
        List<PlanItem<?>> list = this.getTargetPlanItems(case_);
        for (int i = list.size() - 1; i >= 0; --i) {
            bl = bl || case_.makePlanItemTransition(list.get(i), this.transition);
        }
        if (!bl) {
            return new CaseNotModifiedResponse(this);
        }
        return new CaseResponse(this);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.identifier, this.identifier);
        this.writeField(jsonGenerator, (Object)Fields.transition, this.transition);
    }
}

