/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.command.plan.task;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.ValueMap;

@Manifest
public class CompleteTask
extends CaseCommand {
    protected final String taskId;
    protected final ValueMap taskOutput;
    protected Task<?> task;

    public CompleteTask(ModelActor modelActor, ValueMap valueMap) {
        super(modelActor.getCurrentUser().asCaseUserIdentity(), modelActor.getParentActorId());
        this.taskId = modelActor.getId();
        this.taskOutput = valueMap;
    }

    public CompleteTask(ValueMap valueMap) {
        super(valueMap);
        this.taskId = valueMap.readString((Object)Fields.taskId, new String[0]);
        this.taskOutput = valueMap.readMap((Object)Fields.taskOutput);
    }

    @Override
    public void validate(Case case_) {
        if (this.taskId == null || this.taskId.trim().isEmpty()) {
            throw new InvalidCommandException("Invalid or missing task id");
        }
        PlanItem<?> planItem = this.getPlanItem(case_);
        if (planItem == null) {
            throw new InvalidCommandException("Invalid or missing task id");
        }
        if (!(planItem instanceof Task)) {
            throw new InvalidCommandException("Invalid or missing task id");
        }
        this.task = (Task)planItem;
    }

    public CaseResponse process(Case case_) {
        this.task.goComplete(this.taskOutput);
        return new CaseResponse(this);
    }

    private PlanItem<?> getPlanItem(Case case_) {
        return case_.getPlanItemById(this.taskId);
    }

    @Override
    public String toString() {
        String string = this.task != null ? this.task.getName() + " with id " + this.taskId : this.taskId + " (unknown name)";
        return "CompleteTask " + string + " with output\n" + this.taskOutput;
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.taskId, this.taskId);
        this.writeField(jsonGenerator, (Object)Fields.taskOutput, this.taskOutput);
    }
}

