/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.file;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.file.CaseFileEvent;
import org.cafienne.cmmn.definition.casefile.PropertyDefinition;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

public abstract class BusinessIdentifierEvent
extends CaseFileEvent {
    public final String name;
    public final String type;

    protected BusinessIdentifierEvent(CaseFileItem caseFileItem, PropertyDefinition propertyDefinition) {
        super(caseFileItem);
        this.name = propertyDefinition.getName();
        this.type = propertyDefinition.getPropertyType().toString();
    }

    protected BusinessIdentifierEvent(ValueMap valueMap) {
        super(valueMap);
        this.name = valueMap.readString((Object)Fields.name, new String[0]);
        this.type = valueMap.readString((Object)Fields.type, new String[0]);
    }

    @Override
    protected void updateState(CaseFileItem caseFileItem) {
        caseFileItem.publishTransition(this);
    }

    public abstract Value<?> getValue();

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "[" + this.name + "]";
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeCaseFileEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.name, this.name);
        this.writeField(jsonGenerator, (Object)Fields.type, this.type);
    }
}

