/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.file;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemTransitioned;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.casefile.CaseFileItemCollection;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.cafienne.cmmn.instance.casefile.InvalidPathException;
import org.cafienne.cmmn.instance.casefile.Path;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

@Manifest
public class CaseFileItemChildRemoved
extends CaseFileItemTransitioned {
    private final Path childPath;

    public CaseFileItemChildRemoved(CaseFileItemCollection caseFileItemCollection, Path path) {
        super(caseFileItemCollection, State.Available, CaseFileItemTransition.RemoveChild, Value.NULL);
        this.childPath = path;
    }

    public CaseFileItemChildRemoved(ValueMap valueMap) {
        super(valueMap);
        this.childPath = valueMap.readPath((Object)Fields.childPath);
    }

    public Path getChildPath() {
        return this.childPath;
    }

    @Override
    public boolean hasBehavior() {
        return false;
    }

    @Override
    public void updateState(Case case_) {
        try {
            Object c = this.path.resolve(case_);
            ((CaseFileItemCollection)c).updateState(this);
        }
        catch (InvalidPathException invalidPathException) {
            logger.error("Could not recover path on case instance?!", (Throwable)invalidPathException);
        }
    }

    @Override
    public String getDescription() {
        return this.getClass().getSimpleName() + "['" + this.path.getPart() + "']. child: [" + this.childPath + "]";
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.write(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.childPath, this.childPath);
    }
}

