/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.plan;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class PlanItemEvent
extends CasePlanEvent<PlanItem<?>> {
    public final int seqNo;
    public final int index;

    protected PlanItemEvent(PlanItem<?> planItem) {
        this(planItem.getCaseInstance(), planItem.getId(), planItem.getType(), planItem.getIndex(), planItem.getNextEventNumber(), planItem);
    }

    protected PlanItemEvent(Case case_, String string, String string2, int n, int n2) {
        this(case_, string, string2, n, n2, null);
    }

    protected PlanItemEvent(Case case_, String string, String string2, int n, int n2, PlanItem<?> planItem) {
        super(case_, string, string2);
        this.seqNo = n2;
        this.index = n;
    }

    protected PlanItemEvent(ValueMap valueMap) {
        super(valueMap);
        ValueMap valueMap2 = valueMap.readMap((Object)Fields.planitem);
        this.seqNo = ((Long)valueMap2.raw((Object)Fields.seqNo)).intValue();
        this.index = ((Long)valueMap2.raw((Object)Fields.index)).intValue();
    }

    public void writePlanItemEvent(JsonGenerator jsonGenerator) throws IOException {
        super.writeCasePlanEvent(jsonGenerator);
        jsonGenerator.writeFieldName(Fields.planitem.toString());
        jsonGenerator.writeStartObject();
        jsonGenerator.writeNumberField(Fields.seqNo.toString(), this.seqNo);
        jsonGenerator.writeNumberField(Fields.index.toString(), this.index);
        jsonGenerator.writeEndObject();
    }

    @Override
    public void updateState(PlanItem<?> planItem) {
        planItem.updateSequenceNumber(this);
        this.updatePlanItemState(planItem);
    }

    protected abstract void updatePlanItemState(PlanItem<?> var1);

    protected String getName() {
        return this.getPlanItem() != null ? ((PlanItem)this.getPlanItem()).getName() + "." + this.getIndex() : "PlanItem";
    }

    public String getId() {
        return this.getPlanItemId() + "_" + this.seqNo;
    }

    public int getSequenceNumber() {
        return this.seqNo;
    }

    public int getIndex() {
        return this.index;
    }
}

