/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.plan.task;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import org.cafienne.cmmn.actorapi.event.plan.CasePlanEvent;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class TaskEvent<T extends Task<?>>
extends CasePlanEvent<T> {
    public final String taskId;
    private final String taskName;

    protected TaskEvent(T t) {
        super(t);
        this.taskName = ((PlanItem)t).getName();
        this.taskId = ((PlanItem)t).getId();
    }

    protected TaskEvent(ValueMap valueMap) {
        super(valueMap);
        this.taskName = valueMap.readString((Object)Fields.taskName, new String[0]);
        this.taskId = valueMap.readString((Object)Fields.taskId, super.getPlanItemId());
    }

    public String getTaskId() {
        return this.getPlanItemId();
    }

    public void writeTaskEvent(JsonGenerator jsonGenerator) throws IOException {
        super.writeCasePlanEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.taskName, this.taskName);
        this.writeField(jsonGenerator, (Object)Fields.taskId, this.taskId);
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        this.writeTaskEvent(jsonGenerator);
    }

    @Override
    public String getPlanItemId() {
        return this.taskId;
    }

    public String getTaskName() {
        return this.taskName;
    }
}

