/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.actorapi.event.team.deprecated.user;

import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.util.Set;
import java.util.stream.Collectors;
import org.cafienne.cmmn.actorapi.event.team.deprecated.DeprecatedCaseTeamEvent;
import org.cafienne.infrastructure.serialization.Fields;
import org.cafienne.json.ValueMap;

public abstract class DeprecatedCaseTeamUserEvent
extends DeprecatedCaseTeamEvent {
    protected final String userId;
    protected final Set<String> roles;

    protected DeprecatedCaseTeamUserEvent(ValueMap valueMap) {
        super(valueMap);
        this.userId = valueMap.readString((Object)Fields.userId, new String[0]);
        this.roles = valueMap.readSet((Object)Fields.roles);
    }

    @Override
    public boolean isUserEvent() {
        return true;
    }

    @Override
    public String getId() {
        return this.userId;
    }

    public String getUserId() {
        return this.userId;
    }

    public Set<String> getRoles() {
        return this.roles;
    }

    @Override
    public String getDescription() {
        if (this.roles.size() == 1) {
            return this.getClass().getSimpleName() + "['" + this.userId + "' left team]";
        }
        String string2 = this.roles.stream().filter(string -> !string.isBlank()).map(string -> "'" + string + "'").collect(Collectors.joining(", "));
        return this.getClass().getSimpleName() + "['" + this.userId + "' with roles " + string2 + " left the team]";
    }

    @Override
    public void write(JsonGenerator jsonGenerator) throws IOException {
        super.writeCaseTeamEvent(jsonGenerator);
        this.writeField(jsonGenerator, (Object)Fields.userId, this.userId);
        this.writeField(jsonGenerator, (Object)Fields.roles, this.roles);
    }
}

