/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ItemControlDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.MilestoneDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.definition.sentry.EntryCriterionDefinition;
import org.cafienne.cmmn.definition.sentry.ExitCriterionDefinition;
import org.w3c.dom.Element;

public class PlanItemDefinition
extends CMMNElementDefinition
implements ItemDefinition {
    private ItemControlDefinition planItemControl;
    private PlanItemDefinitionDefinition definition;
    private final Collection<EntryCriterionDefinition> entryCriteria = new ArrayList<EntryCriterionDefinition>();
    private final Collection<ExitCriterionDefinition> exitCriteria = new ArrayList<ExitCriterionDefinition>();
    private final String planItemDefinitionRefValue = this.parseAttribute("definitionRef", true, new String[0]);

    public PlanItemDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
        this.parse("entryCriterion", EntryCriterionDefinition.class, this.entryCriteria);
        this.parse("exitCriterion", ExitCriterionDefinition.class, this.exitCriteria);
        this.planItemControl = this.parse("itemControl", ItemControlDefinition.class, false);
    }

    @Override
    public String toString() {
        return this.definition.getType() + "['" + this.getName() + "']";
    }

    @Override
    public ItemControlDefinition getPlanItemControl() {
        return this.planItemControl;
    }

    @Override
    public PlanItemDefinitionDefinition getPlanItemDefinition() {
        if (this.definition == null) {
            this.resolvePlanItemDefinition();
        }
        return this.definition;
    }

    @Override
    public Collection<EntryCriterionDefinition> getEntryCriteria() {
        return this.entryCriteria;
    }

    @Override
    public Collection<ExitCriterionDefinition> getExitCriteria() {
        return this.exitCriteria;
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.resolvePlanItemDefinition();
        if (this.definition == null) {
            this.getCaseDefinition().addReferenceError(this.getContextDescription() + " refers to a definition named " + this.planItemDefinitionRefValue + ", but that definition is not found");
            return;
        }
        if (this.getName().isEmpty()) {
            this.setName(this.definition.getName());
        }
        if (this.planItemControl == null && this.definition != null) {
            this.planItemControl = this.definition.getDefaultControl();
        }
        if (this.definition instanceof TaskDefinition && !((TaskDefinition)this.definition).isBlocking() && !this.exitCriteria.isEmpty()) {
            this.getCaseDefinition().addDefinitionError(this.getContextDescription() + " has exit sentries, but these are not allowed for a non blocking task");
            return;
        }
        if (!this.planItemControl.getRepetitionRule().isDefault()) {
            if (this.entryCriteria.isEmpty()) {
                if (this.definition instanceof MilestoneDefinition) {
                    this.getCaseDefinition().addDefinitionError(this.getContextDescription() + " has a repetition rule defined, but no entry criteria. This is mandatory.");
                }
            } else if (this.getEntryCriteria().stream().noneMatch(EntryCriterionDefinition::hasOnParts)) {
                this.getCaseDefinition().addDefinitionError(this.getContextDescription() + " has a repetition rule defined, but no entry criteria with at least one on part. This is mandatory.");
            }
        }
    }

    @Override
    public String getContextDescription() {
        String string = this.definition != null ? this.definition.getType() : "Plan item";
        return string + " " + this.getName();
    }

    private void resolvePlanItemDefinition() {
        this.definition = this.getCaseDefinition().findPlanItemDefinition(this.planItemDefinitionRefValue);
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::samePlanItem);
    }

    public boolean samePlanItem(PlanItemDefinition planItemDefinition) {
        return this.sameIdentifiers(planItemDefinition) && this.same(this.planItemControl, planItemDefinition.planItemControl) && this.same(this.definition, planItemDefinition.definition) && this.same(this.entryCriteria, planItemDefinition.entryCriteria) && this.same(this.exitCriteria, planItemDefinition.exitCriteria);
    }
}

