/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import org.cafienne.cmmn.definition.ApplicabilityRuleDefinition;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.DiscretionaryItemDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.TableItemDefinition;
import org.cafienne.cmmn.instance.DiscretionaryItem;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Stage;
import org.w3c.dom.Element;

public class PlanningTableDefinition
extends TableItemDefinition {
    private final Collection<TableItemDefinition> tableItems = new ArrayList<TableItemDefinition>();
    private final Collection<ApplicabilityRuleDefinition> ruleDefinitions = new ArrayList<ApplicabilityRuleDefinition>();

    public PlanningTableDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.parse("discretionaryItem", DiscretionaryItemDefinition.class, this.tableItems);
        this.parse("planningTable", PlanningTableDefinition.class, this.tableItems);
        this.parse("applicabilityRule", ApplicabilityRuleDefinition.class, this.ruleDefinitions);
    }

    ApplicabilityRuleDefinition getApplicabilityRule(String string) {
        return this.ruleDefinitions.stream().filter(applicabilityRuleDefinition -> applicabilityRuleDefinition.getName().equals(string) || applicabilityRuleDefinition.getId().equals(string)).findFirst().orElse(null);
    }

    @Override
    public Element dumpMemoryStateToXML(Element element, Stage<?> stage) {
        Element element2 = element.getOwnerDocument().createElement("PlanningTable");
        element.appendChild(element2);
        super.dumpMemoryStateToXML(element2, stage);
        for (TableItemDefinition tableItemDefinition : this.tableItems) {
            tableItemDefinition.dumpMemoryStateToXML(element2, stage);
        }
        return element2;
    }

    public boolean hasItems(PlanItem<?> planItem) {
        if (!this.isPlanningAllowed((PlanItem)planItem)) {
            return false;
        }
        for (TableItemDefinition tableItemDefinition : this.tableItems) {
            if (tableItemDefinition instanceof DiscretionaryItemDefinition) {
                return true;
            }
            if (!(tableItemDefinition instanceof PlanningTableDefinition) || !((PlanningTableDefinition)tableItemDefinition).hasItems(planItem)) continue;
            return true;
        }
        return false;
    }

    @Override
    public void evaluate(PlanItem<?> planItem, Collection<DiscretionaryItem> collection) {
        if (this.isPlanningAllowed((PlanItem)planItem)) {
            this.tableItems.forEach(tableItemDefinition -> tableItemDefinition.evaluate(planItem, collection));
        }
    }

    @Override
    protected DiscretionaryItemDefinition getDiscretionaryItem(String string) {
        for (TableItemDefinition tableItemDefinition : this.tableItems) {
            DiscretionaryItemDefinition discretionaryItemDefinition = tableItemDefinition.getDiscretionaryItem(string);
            if (discretionaryItemDefinition == null) continue;
            return discretionaryItemDefinition;
        }
        return null;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::samePlanningTable);
    }

    public boolean samePlanningTable(PlanningTableDefinition planningTableDefinition) {
        return this.sameTableItem(planningTableDefinition) && this.same(this.tableItems, planningTableDefinition.tableItems) && this.same(this.ruleDefinitions, planningTableDefinition.ruleDefinitions);
    }
}

