/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition;

import java.util.ArrayList;
import java.util.Collection;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.CaseTaskDefinition;
import org.cafienne.cmmn.definition.DiscretionaryItemDefinition;
import org.cafienne.cmmn.definition.HumanTaskDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.MilestoneDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.PlanFragmentDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinition;
import org.cafienne.cmmn.definition.PlanItemDefinitionDefinition;
import org.cafienne.cmmn.definition.PlanningTableDefinition;
import org.cafienne.cmmn.definition.ProcessTaskDefinition;
import org.cafienne.cmmn.definition.TimerEventDefinition;
import org.cafienne.cmmn.definition.UserEventDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Stage;
import org.w3c.dom.Element;

public class StageDefinition
extends PlanFragmentDefinition {
    private final Collection<PlanItemDefinitionDefinition> planItemDefinitions = new ArrayList<PlanItemDefinitionDefinition>();
    private final boolean autoComplete;
    private final PlanningTableDefinition planningTable;

    public StageDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        this.parse("humanTask", HumanTaskDefinition.class, this.planItemDefinitions);
        this.parse("processTask", ProcessTaskDefinition.class, this.planItemDefinitions);
        this.parse("caseTask", CaseTaskDefinition.class, this.planItemDefinitions);
        this.parse("milestone", MilestoneDefinition.class, this.planItemDefinitions);
        this.parse("userEvent", UserEventDefinition.class, this.planItemDefinitions);
        this.parse("timerEvent", TimerEventDefinition.class, this.planItemDefinitions);
        this.parse("stage", StageDefinition.class, this.planItemDefinitions);
        this.autoComplete = Boolean.parseBoolean(this.parseAttribute("autoComplete", false, "false"));
        this.planningTable = this.parse("planningTable", PlanningTableDefinition.class, false);
    }

    public boolean autoCompletes() {
        return this.autoComplete;
    }

    public PlanningTableDefinition getPlanningTable() {
        return this.planningTable;
    }

    public DiscretionaryItemDefinition getDiscretionaryItem(String string) {
        DiscretionaryItemDefinition discretionaryItemDefinition;
        block2: {
            discretionaryItemDefinition = null;
            if (this.planningTable != null) {
                discretionaryItemDefinition = this.planningTable.getDiscretionaryItem(string);
            }
            if (discretionaryItemDefinition != null) break block2;
            for (PlanItemDefinition planItemDefinition : this.getPlanItems()) {
                HumanTaskDefinition humanTaskDefinition;
                PlanningTableDefinition planningTableDefinition;
                if (planItemDefinition.getPlanItemDefinition() instanceof HumanTaskDefinition && (planningTableDefinition = (humanTaskDefinition = (HumanTaskDefinition)planItemDefinition.getPlanItemDefinition()).getPlanningTable()) != null && (discretionaryItemDefinition = humanTaskDefinition.getPlanningTable().getDiscretionaryItem(string)) != null) break;
            }
        }
        return discretionaryItemDefinition;
    }

    public Collection<PlanItemDefinitionDefinition> getPlanItemDefinitions() {
        return this.planItemDefinitions;
    }

    public Stage<?> createInstance(String string, int n, ItemDefinition itemDefinition, Stage<?> stage, Case case_) {
        return new Stage<StageDefinition>(string, n, itemDefinition, this, stage, case_);
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameStage);
    }

    public boolean sameStage(StageDefinition stageDefinition) {
        return this.samePlanFragment(stageDefinition) && this.same((Object)this.autoComplete, (Object)stageDefinition.autoComplete) && this.same(this.planningTable, stageDefinition.planningTable);
    }
}

