/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.casefile;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.stream.Collectors;
import org.cafienne.cmmn.definition.DefinitionsDocument;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.casefile.DefinitionType;
import org.cafienne.cmmn.definition.casefile.ImportDefinition;
import org.cafienne.cmmn.definition.casefile.PropertyDefinition;
import org.w3c.dom.Element;

public class CaseFileItemDefinitionDefinition
extends ModelDefinition {
    private final DefinitionType definitionType;
    private final String structureRef;
    private final String importRef;
    private ImportDefinition importDefinition;
    private final Map<String, PropertyDefinition> properties = new LinkedHashMap<String, PropertyDefinition>();

    public CaseFileItemDefinitionDefinition(Element element, DefinitionsDocument definitionsDocument) {
        super(element, definitionsDocument);
        this.definitionType = this.readDefinitionType();
        this.structureRef = this.parseAttribute("structureRef", false, "");
        this.importRef = this.parseAttribute("importRef", false, "");
        this.parse("property", PropertyDefinition.class, this.properties);
    }

    private DefinitionType readDefinitionType() {
        String string = this.parseAttribute("definitionType", false, "http://www.omg.org/spec/CMMN/DefinitionType/Unspecified");
        return DefinitionType.resolveDefinitionType(string);
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        if (!this.importRef.isEmpty()) {
            this.importDefinition = this.getModelDefinition().getDefinitionsDocument().getImportDefinition(this.importRef);
            if (this.importDefinition == null) {
                super.addReferenceError("The case file item definition '" + this.getName() + "' refers to an import named " + this.importRef + ", but that definition is not found");
            }
        }
    }

    public DefinitionType getDefinitionType() {
        return this.definitionType;
    }

    public String getStructureRef() {
        return this.structureRef;
    }

    public ImportDefinition getImport() {
        return this.importDefinition;
    }

    public Map<String, PropertyDefinition> getProperties() {
        return this.properties;
    }

    public Collection<PropertyDefinition> getBusinessIdentifiers() {
        return this.properties.values().stream().filter(PropertyDefinition::isBusinessIdentifier).collect(Collectors.toList());
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameCaseFileItemDefinitionDefinition);
    }

    public boolean sameCaseFileItemDefinitionDefinition(CaseFileItemDefinitionDefinition caseFileItemDefinitionDefinition) {
        return this.sameModelDefinition(caseFileItemDefinitionDefinition) && this.same(this.definitionType, caseFileItemDefinitionDefinition.definitionType) && this.same(this.structureRef, caseFileItemDefinitionDefinition.structureRef) && this.same(this.importDefinition, caseFileItemDefinitionDefinition.importDefinition) && this.same(this.properties.values(), caseFileItemDefinitionDefinition.properties.values());
    }
}

