/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.casefile;

import org.cafienne.cmmn.definition.casefile.CaseFileError;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.definition.casefile.definitiontype.UnknownType;
import org.cafienne.cmmn.definition.casefile.definitiontype.UnspecifiedType;
import org.cafienne.cmmn.definition.casefile.definitiontype.XMLComplexType;
import org.cafienne.cmmn.definition.casefile.definitiontype.XMLElementType;
import org.cafienne.cmmn.definition.casefile.definitiontype.XMLSimpleType;
import org.cafienne.json.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefinitionType {
    private static final Logger logger = LoggerFactory.getLogger(DefinitionType.class);

    public static DefinitionType resolveDefinitionType(String string) {
        if (!(string.equals("http://www.omg.org/spec/CMMN/DefinitionType/CMISFolder") || string.equals("http://www.omg.org/spec/CMMN/DefinitionType/CMISDocument") || string.equals("http://www.omg.org/spec/CMMN/DefinitionType/CMISRelationship"))) {
            if (string.equals("http://www.omg.org/spec/CMMN/DefinitionType/XSDElement")) {
                return new XMLElementType();
            }
            if (string.equals("http://www.omg.org/spec/CMMN/DefinitionType/XSDComplexType")) {
                return new XMLComplexType();
            }
            if (string.equals("http://www.omg.org/spec/CMMN/DefinitionType/XSDSimpleType")) {
                return new XMLSimpleType();
            }
            if (!string.equals("http://www.omg.org/spec/CMMN/DefinitionType/WSDLMessage") && !string.equals("http://www.omg.org/spec/CMMN/DefinitionType/UMLClass")) {
                if (string.equals("http://www.omg.org/spec/CMMN/DefinitionType/Unknown")) {
                    return new UnknownType();
                }
                if (string.equals("http://www.omg.org/spec/CMMN/DefinitionType/Unspecified")) {
                    return new UnspecifiedType();
                }
            }
        }
        logger.debug("Creating UnknownType wrapper for unrecognized type " + string);
        return new UnknownType(string);
    }

    public void validate(CaseFileItemDefinition caseFileItemDefinition, Value<?> value) throws CaseFileError {
    }
}

