/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.casefile.definitiontype;

import java.util.List;
import java.util.Map;
import org.cafienne.cmmn.definition.casefile.CaseFileError;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.definition.casefile.DefinitionType;
import org.cafienne.cmmn.definition.casefile.PropertyDefinition;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;

public class JSONType
extends DefinitionType {
    @Override
    public void validate(CaseFileItemDefinition caseFileItemDefinition, Value<?> value2) throws CaseFileError {
        if (value2.isMap()) {
            this.validateItem(value2.asMap(), caseFileItemDefinition);
        } else if (value2.isList() && caseFileItemDefinition.getMultiplicity().isIterable()) {
            ((List)value2.asList().getValue()).forEach(value -> {
                if (value.isMap()) {
                    this.validateItem(value.asMap(), caseFileItemDefinition);
                }
            });
        }
    }

    private void validateItem(ValueMap valueMap, CaseFileItemDefinition caseFileItemDefinition) {
        Map<String, PropertyDefinition> map = caseFileItemDefinition.getCaseFileItemDefinition().getProperties();
        ((Map)valueMap.asMap().getValue()).forEach((string, value) -> {
            PropertyDefinition propertyDefinition = (PropertyDefinition)map.get(string);
            if (propertyDefinition != null) {
                this.validateProperty(propertyDefinition, (Value<?>)value);
            } else {
                CaseFileItemDefinition caseFileItemDefinition2 = caseFileItemDefinition.getChild((String)string);
                if (caseFileItemDefinition2 != null) {
                    caseFileItemDefinition2.validatePropertyTypes((Value<?>)value);
                }
            }
        });
    }

    private void validateProperty(PropertyDefinition propertyDefinition, Value<?> value) {
        if (value == null || value == Value.NULL) {
            return;
        }
        PropertyDefinition.PropertyType propertyType = propertyDefinition.getPropertyType();
        try {
            if (!value.matches(propertyType)) {
                throw new CaseFileError("Property '" + propertyDefinition.getName() + "' has wrong type, expecting " + propertyType + ", found a " + value.getClass().getSimpleName());
            }
        }
        catch (IllegalArgumentException illegalArgumentException) {
            throw new CaseFileError("Property '" + propertyDefinition.getName() + "' has wrong type, expecting " + propertyType + ", found exception " + illegalArgumentException.getMessage());
        }
    }
}

