/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.parameter;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.definition.parameter.BindingRefinementDefinition;
import org.w3c.dom.Element;

public class ParameterDefinition
extends CMMNElementDefinition {
    private final String bindingRef = this.parseAttribute("bindingRef", false, "");
    private CaseFileItemDefinition binding;
    private final BindingRefinementDefinition bindingRefinement = this.parse("bindingRefinement", BindingRefinementDefinition.class, false);

    public ParameterDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition, new boolean[0]);
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        if (!this.bindingRef.isEmpty()) {
            this.binding = this.getCaseDefinition().findCaseFileItem(this.bindingRef);
            if (this.binding == null) {
                this.getModelDefinition().addReferenceError("The parameter " + this.getName() + " has a binding to '" + this.bindingRef + "' but the corresponding case file item cannot be found");
            }
        }
    }

    @Override
    public String getContextDescription() {
        return "The parameter " + this.getName();
    }

    public CaseFileItemDefinition getBinding() {
        return this.binding;
    }

    public BindingRefinementDefinition getBindingRefinement() {
        return this.bindingRefinement;
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameParameter);
    }

    public boolean sameBinding(ParameterDefinition parameterDefinition) {
        return this.same(this.binding, parameterDefinition.binding);
    }

    public boolean sameBindingRefinement(ParameterDefinition parameterDefinition) {
        return this.same(this.bindingRefinement, parameterDefinition.bindingRefinement);
    }

    public boolean sameParameter(ParameterDefinition parameterDefinition) {
        return this.sameIdentifiers(parameterDefinition) && this.sameBinding(parameterDefinition) && this.sameBindingRefinement(parameterDefinition);
    }
}

