/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.definition.sentry;

import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ModelDefinition;
import org.cafienne.cmmn.definition.XMLElementDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.definition.sentry.OnPartDefinition;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.cafienne.cmmn.instance.sentry.CaseFileItemOnPart;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.w3c.dom.Element;

public class CaseFileItemOnPartDefinition
extends OnPartDefinition {
    private final CaseFileItemTransition standardEvent;
    private final String sourceRef;
    private CaseFileItemDefinition source;

    public CaseFileItemOnPartDefinition(Element element, ModelDefinition modelDefinition, CMMNElementDefinition cMMNElementDefinition) {
        super(element, modelDefinition, cMMNElementDefinition);
        String string = this.parseString("standardEvent", true, new String[0]);
        this.standardEvent = CaseFileItemTransition.getEnum(string);
        if (this.standardEvent == null) {
            this.getCaseDefinition().addDefinitionError("A standard event named " + string + " does not exist for case file items");
        }
        this.sourceRef = this.parseAttribute("sourceRef", true, new String[0]);
    }

    @Override
    protected void resolveReferences() {
        super.resolveReferences();
        this.source = this.getCaseDefinition().findCaseFileItem(this.sourceRef);
        if (this.source == null) {
            this.getModelDefinition().addReferenceError("A case file item with name '" + this.sourceRef + "' is referenced from sentry " + ((XMLElementDefinition)this.getParentElement()).getName() + ", but it does not exist in the case file model");
        }
    }

    @Override
    public String getContextDescription() {
        return this.source.getType() + "[" + this.source.getPath() + "]." + this.standardEvent;
    }

    public CaseFileItemTransition getStandardEvent() {
        return this.standardEvent;
    }

    @Override
    public CaseFileItemDefinition getSourceDefinition() {
        return this.source;
    }

    public CaseFileItemOnPart createInstance(Criterion<?> criterion) {
        return new CaseFileItemOnPart(criterion, this);
    }

    @Override
    protected boolean equalsWith(Object object) {
        return this.equalsWith(object, this::sameOnPart);
    }

    public boolean sameOnPart(CaseFileItemOnPartDefinition caseFileItemOnPartDefinition) {
        return this.same((Object)this.standardEvent, (Object)caseFileItemOnPartDefinition.standardEvent) && this.same(this.source, caseFileItemOnPartDefinition.source);
    }
}

