/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.spel;

import org.cafienne.actormodel.ModelActor;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.expression.InvalidExpressionException;
import org.cafienne.cmmn.expression.spel.SpelReadableRecognizer;
import org.cafienne.cmmn.expression.spel.api.APIRootObject;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.EvaluationException;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

public class Evaluator {
    private final ExpressionParser parser = new SpelExpressionParser();
    private final Expression expression;
    private final String source;
    private final CMMNElementDefinition definition;

    public Evaluator(CMMNElementDefinition cMMNElementDefinition, String string) {
        this.definition = cMMNElementDefinition;
        this.source = string;
        this.expression = this.parseExpression();
    }

    public boolean isValid() {
        return this.expression != null;
    }

    public Expression getExpression() {
        return this.expression;
    }

    private Expression parseExpression() {
        if (this.source.isBlank()) {
            this.definition.getModelDefinition().addDefinitionError(this.definition.getContextDescription() + " has no expression");
            return null;
        }
        try {
            return this.parser.parseExpression(this.source);
        }
        catch (Exception exception) {
            this.definition.getModelDefinition().addDefinitionError(this.definition.getContextDescription() + " has an invalid expression:\n" + exception.getMessage());
            return null;
        }
    }

    public <T> T evaluate(APIRootObject<?> aPIRootObject) {
        Object t = aPIRootObject.getActor();
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext(aPIRootObject);
        SpelReadableRecognizer spelReadableRecognizer = new SpelReadableRecognizer((ModelActor)((Object)t));
        standardEvaluationContext.addPropertyAccessor((PropertyAccessor)spelReadableRecognizer);
        try {
            ((ModelActor)((Object)t)).addDebugInfo(() -> "Evaluating " + aPIRootObject.getDescription() + ": " + this.source.trim(), new Object[0]);
            Object object = this.expression.getValue((EvaluationContext)standardEvaluationContext);
            String string = object == null ? "NULL" : object.getClass().getSimpleName();
            ((ModelActor)((Object)t)).addDebugInfo(() -> "Outcome has type " + string + " and value: " + object, new Object[0]);
            return (T)object;
        }
        catch (EvaluationException evaluationException) {
            ((ModelActor)((Object)t)).addDebugInfo(() -> "Failure in evaluating " + aPIRootObject.getDescription() + ", with expression " + this.source.trim(), new Object[]{evaluationException});
            throw new InvalidExpressionException("Could not evaluate " + this.expression.getExpressionString() + "\n" + evaluationException.getLocalizedMessage(), evaluationException);
        }
    }
}

