/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.spel;

import java.time.Duration;
import java.time.Instant;
import java.time.format.DateTimeParseException;
import java.util.Date;
import java.util.Map;
import org.cafienne.cmmn.definition.ApplicabilityRuleDefinition;
import org.cafienne.cmmn.definition.CMMNElementDefinition;
import org.cafienne.cmmn.definition.ConstraintDefinition;
import org.cafienne.cmmn.definition.DiscretionaryItemDefinition;
import org.cafienne.cmmn.definition.ExpressionDefinition;
import org.cafienne.cmmn.definition.TimerEventDefinition;
import org.cafienne.cmmn.definition.parameter.ParameterDefinition;
import org.cafienne.cmmn.definition.sentry.IfPartDefinition;
import org.cafienne.cmmn.definition.task.AssignmentDefinition;
import org.cafienne.cmmn.definition.task.DueDateDefinition;
import org.cafienne.cmmn.expression.CMMNExpressionEvaluator;
import org.cafienne.cmmn.expression.InvalidExpressionException;
import org.cafienne.cmmn.expression.spel.Evaluator;
import org.cafienne.cmmn.expression.spel.api.APIRootObject;
import org.cafienne.cmmn.expression.spel.api.cmmn.constraint.ApplicabilityRuleAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.constraint.IfPartAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.constraint.PlanItemRootAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.mapping.TaskInputMappingAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.mapping.TaskOutputMappingAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.plan.TimerExpressionAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.workflow.AssignmentAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.workflow.DueDateAPI;
import org.cafienne.cmmn.expression.spel.api.process.CalculationAPI;
import org.cafienne.cmmn.expression.spel.api.process.OutputMappingRoot;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.TimerEvent;
import org.cafienne.cmmn.instance.parameter.TaskInputParameter;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.cmmn.instance.task.humantask.HumanTask;
import org.cafienne.json.LongValue;
import org.cafienne.json.StringValue;
import org.cafienne.json.Value;
import org.cafienne.processtask.implementation.calculation.Calculation;
import org.cafienne.processtask.implementation.calculation.definition.expression.CalculationExpressionDefinition;
import org.cafienne.processtask.implementation.calculation.definition.source.InputReference;
import org.cafienne.processtask.implementation.calculation.operation.CalculationStep;
import org.cafienne.processtask.instance.ProcessTaskActor;

public class ExpressionEvaluator
implements CMMNExpressionEvaluator {
    private final Evaluator evaluator;
    private final String expressionString;

    public ExpressionEvaluator(ExpressionDefinition expressionDefinition) {
        this(expressionDefinition, expressionDefinition.getBody());
    }

    public ExpressionEvaluator(CalculationExpressionDefinition calculationExpressionDefinition) {
        this(calculationExpressionDefinition, calculationExpressionDefinition.getExpression());
    }

    public ExpressionEvaluator(CMMNElementDefinition cMMNElementDefinition, String string) {
        this.evaluator = new Evaluator(cMMNElementDefinition, string);
        this.expressionString = string;
    }

    private <T> T evaluateExpression(APIRootObject<?> aPIRootObject) {
        return this.evaluator.evaluate(aPIRootObject);
    }

    private boolean evaluateConstraint(PlanItemRootAPI<?> planItemRootAPI) {
        Object t = this.evaluateExpression(planItemRootAPI);
        if (t instanceof Boolean) {
            return (Boolean)t;
        }
        ((Case)((Object)planItemRootAPI.getActor())).addDebugInfo(() -> "Failure in evaluating " + planItemRootAPI.getDescription() + ", with expression " + this.expressionString.trim() + "\nIt should return something of type boolean instead of type " + t.getClass().getName() + "\nReturning result 'false'", new Object[0]);
        return false;
    }

    @Override
    public Value<?> evaluateInputParameterTransformation(Case case_, TaskInputParameter taskInputParameter, ParameterDefinition parameterDefinition, Task<?> task) {
        return Value.convert(this.evaluateExpression(new TaskInputMappingAPI(taskInputParameter, parameterDefinition, task)));
    }

    @Override
    public Value<?> evaluateOutputParameterTransformation(Case case_, Value<?> value, ParameterDefinition parameterDefinition, ParameterDefinition parameterDefinition2, Task<?> task) {
        return Value.convert(this.evaluateExpression(new TaskOutputMappingAPI(parameterDefinition, parameterDefinition2, value, task)));
    }

    @Override
    public Value<?> evaluateOutputParameterTransformation(ProcessTaskActor processTaskActor, Value<?> value, ParameterDefinition parameterDefinition, ParameterDefinition parameterDefinition2) {
        OutputMappingRoot outputMappingRoot = new OutputMappingRoot(parameterDefinition, value, parameterDefinition2, processTaskActor);
        Object t = this.evaluateExpression(outputMappingRoot);
        return Value.convert(t);
    }

    @Override
    public Duration evaluateTimerExpression(TimerEvent timerEvent, TimerEventDefinition timerEventDefinition) {
        try {
            return Duration.parse(timerEventDefinition.getTimerExpression().getBody().trim());
        }
        catch (DateTimeParseException dateTimeParseException) {
            Object t = this.evaluateExpression(new TimerExpressionAPI(timerEvent));
            if (t instanceof Duration) {
                return (Duration)t;
            }
            try {
                return Duration.parse(String.valueOf(t).trim());
            }
            catch (DateTimeParseException dateTimeParseException2) {
                throw new InvalidExpressionException("The timer expression " + timerEventDefinition.getTimerExpression().getBody() + " in " + timerEventDefinition.getName() + " cannot be parsed into a Duration", dateTimeParseException2);
            }
        }
    }

    @Override
    public boolean evaluateItemControl(PlanItem<?> planItem, ConstraintDefinition constraintDefinition) {
        return this.evaluateConstraint(new PlanItemRootAPI<ConstraintDefinition>(constraintDefinition, planItem));
    }

    @Override
    public boolean evaluateIfPart(Criterion<?> criterion, IfPartDefinition ifPartDefinition) {
        return this.evaluateConstraint(new IfPartAPI(ifPartDefinition, criterion));
    }

    @Override
    public boolean evaluateApplicabilityRule(PlanItem<?> planItem, DiscretionaryItemDefinition discretionaryItemDefinition, ApplicabilityRuleDefinition applicabilityRuleDefinition) {
        return this.evaluateConstraint(new ApplicabilityRuleAPI(planItem, discretionaryItemDefinition, applicabilityRuleDefinition));
    }

    @Override
    public Instant evaluateDueDate(HumanTask humanTask, DueDateDefinition dueDateDefinition) throws InvalidExpressionException {
        Object t = this.evaluateExpression(new DueDateAPI(dueDateDefinition, humanTask));
        if (t == null || t == Value.NULL) {
            return null;
        }
        if (t instanceof Instant) {
            return (Instant)t;
        }
        if (t instanceof Date) {
            return ((Date)t).toInstant();
        }
        if (t instanceof Long) {
            return Instant.ofEpochMilli((Long)t);
        }
        if (t instanceof LongValue) {
            return Instant.ofEpochMilli((Long)((LongValue)t).getValue());
        }
        if (t instanceof String) {
            try {
                return Instant.parse(t.toString());
            }
            catch (DateTimeParseException dateTimeParseException) {
                throw new InvalidExpressionException("Cannot parse string '" + t + "' to Instant: " + dateTimeParseException.getMessage(), dateTimeParseException);
            }
        }
        if (t instanceof StringValue) {
            try {
                return Instant.parse((CharSequence)((StringValue)t).getValue());
            }
            catch (DateTimeParseException dateTimeParseException) {
                throw new InvalidExpressionException("Cannot parse string '" + t + "' to Instant: " + dateTimeParseException.getMessage(), dateTimeParseException);
            }
        }
        throw new InvalidExpressionException("Outcome of due date expression cannot be interpreted as a due date, it is of type " + t.getClass().getName());
    }

    @Override
    public String evaluateAssignee(HumanTask humanTask, AssignmentDefinition assignmentDefinition) throws InvalidExpressionException {
        Object t = this.evaluateExpression(new AssignmentAPI(assignmentDefinition, humanTask));
        if (t == null || t == Value.NULL) {
            return null;
        }
        return t.toString();
    }

    public Value<?> runCalculationStep(Calculation calculation, CalculationStep calculationStep, Map<InputReference, Value<?>> map) throws InvalidExpressionException {
        CalculationAPI calculationAPI = new CalculationAPI(calculation, calculationStep, map);
        Object t = this.evaluateExpression(calculationAPI);
        return Value.convert(t);
    }
}

