/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.spel;

import org.cafienne.actormodel.ModelActor;
import org.cafienne.cmmn.expression.spel.SpelPropertyValueProvider;
import org.cafienne.cmmn.expression.spel.SpelReadable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.expression.AccessException;
import org.springframework.expression.EvaluationContext;
import org.springframework.expression.PropertyAccessor;
import org.springframework.expression.TypedValue;

public class SpelReadableRecognizer
implements PropertyAccessor {
    private static final Logger logger = LoggerFactory.getLogger(SpelReadableRecognizer.class);
    public final ModelActor model;

    public SpelReadableRecognizer(ModelActor modelActor) {
        this.model = modelActor;
    }

    public boolean canRead(EvaluationContext evaluationContext, Object object, String string) throws AccessException {
        boolean bl = false;
        if (object instanceof SpelReadable) {
            bl = ((SpelReadable)object).canRead(string);
        }
        return bl;
    }

    public TypedValue read(EvaluationContext evaluationContext, Object object, String string) throws AccessException {
        if (object instanceof SpelReadable) {
            Object object2 = ((SpelReadable)object).read(string);
            if (object2 instanceof SpelPropertyValueProvider) {
                object2 = ((SpelPropertyValueProvider)object2).getValue();
            }
            this.model.addDebugInfo(() -> "Reading property '" + string + "' results in value: ", object2);
            return new TypedValue(object2);
        }
        if (object == null) {
            this.model.addDebugInfo(() -> "Cannot read property " + string + " from null object", new Object[0]);
        } else {
            this.model.addDebugInfo(() -> "Cannot read property " + string + " from strange context of type " + object.getClass().getName() + ": with value ", object);
        }
        return null;
    }

    public Class<?>[] getSpecificTargetClasses() {
        return null;
    }

    public boolean canWrite(EvaluationContext evaluationContext, Object object, String string) throws AccessException {
        logger.warn("Writing into properties is not supported. Expression is trying to write into property " + string);
        return true;
    }

    public void write(EvaluationContext evaluationContext, Object object, String string, Object object2) throws AccessException {
        logger.warn("Not supported: writing into property " + string + " with value " + object2);
    }
}

