/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.spel.api;

import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.cafienne.actormodel.ModelActor;
import org.cafienne.cmmn.expression.spel.SpelReadable;
import org.cafienne.cmmn.expression.spel.api.ExpressionObjectPropertyReader;
import org.cafienne.json.Value;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APIObject<T extends ModelActor>
implements SpelReadable {
    private static final Logger logger = LoggerFactory.getLogger(APIObject.class);
    private final Set<String> propertyNames = new HashSet<String>();
    private final Set<String> deprecatedNames = new HashSet<String>();
    private final Map<String, ExpressionObjectPropertyReader> readers = new HashMap<String, ExpressionObjectPropertyReader>();
    protected final T actor;

    protected APIObject(T t) {
        this.actor = t;
    }

    public T getActor() {
        return this.actor;
    }

    private void addReader(String string, ExpressionObjectPropertyReader expressionObjectPropertyReader) {
        this.propertyNames.add(string);
        this.readers.put(string.toLowerCase(), expressionObjectPropertyReader);
    }

    protected void addProperty(String string, Object object) {
        this.addPropertyReader(string, () -> object);
    }

    protected void addContextProperty(APIObject<T> aPIObject, String string, String string2) {
        this.addPropertyReader(string, () -> aPIObject);
        this.addDeprecatedReader(string2, string, () -> aPIObject);
    }

    protected void addPropertyReader(String string, ExpressionObjectPropertyReader expressionObjectPropertyReader) {
        if (string != null) {
            this.addReader(string, expressionObjectPropertyReader);
        }
    }

    protected void warnDeprecation(String string, String string2) {
        String string3 = "Expression contains deprecated property '" + string + "'; please use property '" + string2 + "' instead";
        logger.warn(string3);
        ((ModelActor)((Object)this.getActor())).addDebugInfo(() -> string2, new Object[0]);
    }

    protected void addDeprecatedReader(String string, String string2, ExpressionObjectPropertyReader expressionObjectPropertyReader) {
        this.deprecatedNames.add(string);
        this.addReader(string, () -> {
            this.warnDeprecation(string, string2);
            return expressionObjectPropertyReader.get();
        });
    }

    protected void addDeprecatedReader(String string, ExpressionObjectPropertyReader expressionObjectPropertyReader) {
        this.deprecatedNames.add(string);
        this.addReader(string, () -> {
            String string2 = "Expression contains unsupported property '" + string + "'. An empty value is given.";
            logger.warn(string2);
            ((ModelActor)((Object)((Object)this.getActor()))).addDebugInfo(() -> string2, new Object[0]);
            return expressionObjectPropertyReader.get();
        });
    }

    @Override
    public boolean canRead(String string) {
        if (!this.readers.containsKey(string.toLowerCase())) {
            HashSet<String> hashSet = new HashSet<String>(this.propertyNames);
            hashSet.removeAll(this.deprecatedNames);
            ((ModelActor)((Object)this.getActor())).addDebugInfo(() -> "Reading property '" + string + "' has no value in " + this.getClass().getSimpleName() + ". Values exist for: " + hashSet, new Object[0]);
        }
        return true;
    }

    @Override
    public Object read(String string) {
        return this.readers.getOrDefault(string.toLowerCase(), () -> Value.NULL).get();
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

