/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.spel.api.cmmn.plan;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import org.cafienne.cmmn.expression.spel.api.APIObject;
import org.cafienne.cmmn.expression.spel.api.cmmn.file.CaseFileAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.plan.PlanItemAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.plan.StageAPI;
import org.cafienne.cmmn.expression.spel.api.cmmn.team.CaseTeamAPI;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;

public class CaseAPI
extends APIObject<Case> {
    private final StageAPI casePlan;
    private final CaseTeamAPI caseTeam;
    private final CaseFileAPI caseFile;
    private final Map<String, PlanItemAPI<?>> planItems = new HashMap();

    public CaseAPI(Case case_) {
        super(case_);
        this.casePlan = new StageAPI(this, case_.getCasePlan(), null);
        this.caseTeam = new CaseTeamAPI(case_.getCaseTeam());
        this.caseFile = new CaseFileAPI(case_.getCaseFile());
        this.addPropertyReader("plan", () -> this.casePlan);
        this.addPropertyReader("file", () -> this.caseFile);
        this.addPropertyReader("team", () -> this.caseTeam);
        this.addPropertyReader("id", case_::getId);
        this.addPropertyReader("name", () -> case_.getDefinition().getName());
        this.addPropertyReader("tenant", case_::getTenant);
        this.addPropertyReader("parent", case_::getParentCaseId);
        this.addPropertyReader("root", case_::getRootCaseId);
        this.addPropertyReader("createdOn", case_::getCreatedOn);
        this.addPropertyReader("lastModified", case_::getLastModified);
        this.addDeprecatedReader("caseFile", "file", () -> this.caseFile);
    }

    protected void register(PlanItemAPI<?> planItemAPI) {
        this.planItems.put(((PlanItem)planItemAPI.item).getId(), planItemAPI);
    }

    public String getId() {
        this.warnDeprecation("getId()", "id");
        return ((Case)this.actor).getId();
    }

    public Collection<PlanItem<?>> getPlanItems(String string) {
        this.warnDeprecation("getPlanItemByName(\"" + string + "\")", "plan");
        return ((Case)this.actor).getPlanItems(string);
    }

    public PlanItemAPI<?> getPlanItemByName(String string) {
        this.warnDeprecation("getPlanItemByName(\"" + string + "\")", "plan");
        return this.find(((Case)this.actor).getPlanItemByName(string));
    }

    public CaseTeamAPI getCaseTeam() {
        this.warnDeprecation("getCaseTeam()", "team");
        return this.caseTeam;
    }

    public CaseFileAPI getCaseFile() {
        this.warnDeprecation("getCaseFile()", "file");
        return this.caseFile;
    }

    public PlanItemAPI<?> find(PlanItem<?> planItem) {
        PlanItemAPI<?> planItemAPI = this.planItems.get(planItem.getId());
        if (planItemAPI == null) {
            ((Case)((Object)this.getActor())).addDebugInfo(() -> "ERROR: Unexpectedly cannot find a PlanItemAPI object for " + planItem, new Object[0]);
        }
        return planItemAPI;
    }
}

