/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.expression.xpath;

import java.io.ByteArrayInputStream;
import java.time.Duration;
import java.time.format.DateTimeParseException;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.xml.namespace.NamespaceContext;
import javax.xml.xpath.XPathFactory;
import org.cafienne.actormodel.exception.CommandException;
import org.cafienne.cmmn.definition.ApplicabilityRuleDefinition;
import org.cafienne.cmmn.definition.ConstraintDefinition;
import org.cafienne.cmmn.definition.DiscretionaryItemDefinition;
import org.cafienne.cmmn.definition.ExpressionDefinition;
import org.cafienne.cmmn.definition.TimerEventDefinition;
import org.cafienne.cmmn.definition.parameter.ParameterDefinition;
import org.cafienne.cmmn.definition.sentry.IfPartDefinition;
import org.cafienne.cmmn.expression.CMMNExpressionEvaluator;
import org.cafienne.cmmn.expression.InvalidExpressionException;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.PlanItem;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.TimerEvent;
import org.cafienne.cmmn.instance.parameter.TaskInputParameter;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.json.BooleanValue;
import org.cafienne.json.Value;
import org.cafienne.util.XMLHelper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;

public class ExpressionEvaluator
implements CMMNExpressionEvaluator {
    private static final Logger logger = LoggerFactory.getLogger(ExpressionEvaluator.class);
    private final String xpathExpression;
    private final ExpressionDefinition definition;
    private final Map<String, String> prefixes = new HashMap<String, String>();

    public ExpressionEvaluator(ExpressionDefinition expressionDefinition) {
        this.xpathExpression = expressionDefinition.getBody();
        this.definition = expressionDefinition;
    }

    private boolean evaluateConstraint(Object object, String string) {
        Object object2;
        Object object3;
        logger.debug("Now evaluating the expression " + this.definition.getBody());
        List<Element> list = XMLHelper.getChildrenWithTagName(this.definition.getElement(), "namespace");
        for (Element object4 : list) {
            object3 = object4.getAttribute("prefix");
            object2 = object4.getAttribute("uri");
            this.prefixes.put((String)object3, (String)object2);
        }
        Element element = this.definition.getElement();
        if (logger.isDebugEnabled()) {
            this.logElementNamespaces(element);
        }
        try {
            XPathFactory exception = XPathFactory.newInstance();
            object3 = exception.newXPath();
            object3.setNamespaceContext(new NamespaceContext(){

                @Override
                public Iterator<String> getPrefixes(String string) {
                    logger.debug("Gettting prefixes for uri " + string);
                    return ExpressionEvaluator.this.prefixes.values().iterator();
                }

                @Override
                public String getPrefix(String string) {
                    logger.debug("Gettting prefix for uri " + string);
                    return "";
                }

                @Override
                public String getNamespaceURI(String string) {
                    logger.debug("Gettting uri for prefix " + string + ", it is: " + ExpressionEvaluator.this.prefixes.get(string));
                    return ExpressionEvaluator.this.prefixes.get(string);
                }
            });
            object2 = object3.compile(this.xpathExpression);
            String string2 = String.valueOf(object);
            ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(string2.getBytes());
            InputSource inputSource = new InputSource(byteArrayInputStream);
            boolean bl = Boolean.valueOf(object2.evaluate(inputSource));
            return bl;
        }
        catch (Exception exception) {
            throw new CommandException("Cannot evaluate XPath expression", exception);
        }
    }

    private void logElementNamespaces(Element element) {
        NamedNodeMap namedNodeMap = element.getAttributes();
        for (int i = 0; i < namedNodeMap.getLength(); ++i) {
            Node node = namedNodeMap.item(i);
            String string = node.getNodeName();
            if (!string.startsWith("xmlns:")) continue;
            String string2 = string.substring(6);
            String string3 = node.getNodeValue();
            logger.debug("NS: " + string2 + "='" + string3 + "'");
        }
    }

    @Override
    public Duration evaluateTimerExpression(TimerEvent timerEvent, TimerEventDefinition timerEventDefinition) {
        try {
            return Duration.parse(timerEventDefinition.getTimerExpression().getBody().trim());
        }
        catch (DateTimeParseException dateTimeParseException) {
            throw new InvalidExpressionException("The timer expression " + timerEventDefinition.getTimerExpression().getBody() + " in " + timerEventDefinition.getName() + " cannot be parsed into a Duration", dateTimeParseException);
        }
    }

    @Override
    public Value<?> evaluateInputParameterTransformation(Case case_, TaskInputParameter taskInputParameter, ParameterDefinition parameterDefinition, Task<?> task) {
        return new BooleanValue(this.evaluateConstraint(taskInputParameter, "x"));
    }

    @Override
    public Value<?> evaluateOutputParameterTransformation(Case case_, Value<?> value, ParameterDefinition parameterDefinition, ParameterDefinition parameterDefinition2, Task<?> task) {
        return new BooleanValue(this.evaluateConstraint(value, "x"));
    }

    @Override
    public boolean evaluateItemControl(PlanItem<?> planItem, ConstraintDefinition constraintDefinition) {
        return false;
    }

    @Override
    public boolean evaluateIfPart(Criterion<?> criterion, IfPartDefinition ifPartDefinition) {
        return false;
    }

    @Override
    public boolean evaluateApplicabilityRule(PlanItem<?> planItem, DiscretionaryItemDefinition discretionaryItemDefinition, ApplicabilityRuleDefinition applicabilityRuleDefinition) {
        return false;
    }
}

