/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import java.util.stream.Collectors;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.cmmn.actorapi.event.plan.task.TaskInputFilled;
import org.cafienne.cmmn.actorapi.event.plan.task.TaskOutputFilled;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.ParameterMappingDefinition;
import org.cafienne.cmmn.definition.TaskDefinition;
import org.cafienne.cmmn.definition.casefile.CaseFileError;
import org.cafienne.cmmn.definition.parameter.InputParameterDefinition;
import org.cafienne.cmmn.definition.parameter.TaskOutputParameterDefinition;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.StateMachine;
import org.cafienne.cmmn.instance.TaskStage;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.TransitionDeniedException;
import org.cafienne.cmmn.instance.parameter.TaskInputParameter;
import org.cafienne.cmmn.instance.parameter.TaskOutputParameter;
import org.cafienne.cmmn.instance.task.validation.ValidationResponse;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.w3c.dom.Element;
import org.w3c.dom.Text;

public abstract class Task<D extends TaskDefinition<?>>
extends TaskStage<D> {
    private ValueMap taskInput = new ValueMap();
    private ValueMap implementationInput = new ValueMap();
    private ValueMap givenOutput = new ValueMap();
    private ValueMap taskOutput = new ValueMap();

    protected Task(String string, int n, ItemDefinition itemDefinition, D d, Stage<?> stage) {
        super(string, n, itemDefinition, d, stage.getCaseInstance(), stage, StateMachine.TaskStage);
    }

    @Override
    protected final void completeInstance() {
    }

    @Override
    protected abstract void terminateInstance();

    @Override
    protected final void startInstance() {
        this.transformInputParameters();
        this.startImplementation(this.implementationInput);
    }

    protected abstract void startImplementation(ValueMap var1);

    @Override
    protected abstract void suspendInstance();

    @Override
    protected abstract void resumeInstance();

    @Override
    protected void reactivateInstance() {
        this.transformInputParameters();
        this.reactivateImplementation(this.implementationInput);
    }

    protected abstract void reactivateImplementation(ValueMap var1);

    @Override
    protected final void failInstance() {
    }

    protected void transformInputParameters() {
        ValueMap valueMap = new ValueMap();
        ValueMap valueMap2 = new ValueMap();
        LinkedHashMap linkedHashMap = new LinkedHashMap();
        ((TaskDefinition)this.getDefinition()).getInputParameters().forEach((string, taskInputParameterDefinition) -> {
            TaskInputParameter taskInputParameter = new TaskInputParameter((InputParameterDefinition)taskInputParameterDefinition, this);
            linkedHashMap.put(string, taskInputParameter);
            valueMap2.put(string, taskInputParameter.getValue());
        });
        Collection<ParameterMappingDefinition> collection = ((TaskDefinition)this.getDefinition()).getParameterMappings();
        for (ParameterMappingDefinition parameterMappingDefinition : collection) {
            if (!parameterMappingDefinition.isInputParameterMapping()) continue;
            TaskInputParameter taskInputParameter = (TaskInputParameter)linkedHashMap.get(parameterMappingDefinition.getSource().getName());
            Value<?> value = parameterMappingDefinition.transformInput(this, taskInputParameter);
            valueMap.put(parameterMappingDefinition.getTarget().getName(), value);
        }
        this.addEvent(new TaskInputFilled(this, valueMap2, valueMap));
    }

    public ValidationResponse validateOutput(ValueMap valueMap) {
        this.transformOutputParameters(valueMap, true);
        return new ValidationResponse(new ValueMap());
    }

    public boolean goComplete(ValueMap valueMap) {
        return this.makeTransitionWithOutput(Transition.Complete, valueMap);
    }

    public void goFault(ValueMap valueMap) {
        this.makeTransitionWithOutput(Transition.Fault, valueMap);
    }

    private boolean makeTransitionWithOutput(Transition transition, ValueMap valueMap) {
        this.prepareTransition(transition);
        ValueMap valueMap2 = this.transformOutputParameters(valueMap, transition == Transition.Complete);
        this.addEvent(new TaskOutputFilled(this, valueMap2, valueMap));
        return super.makeTransition(transition);
    }

    protected ValueMap transformOutputParameters(ValueMap valueMap, boolean bl) {
        ValueMap valueMap2 = valueMap == null ? new ValueMap() : valueMap;
        Collection<ParameterMappingDefinition> collection = ((TaskDefinition)this.getDefinition()).getParameterMappings();
        this.addDebugInfo(() -> {
            List list = collection.stream().filter(parameterMappingDefinition -> !parameterMappingDefinition.isInputParameterMapping() && !valueMap2.has(parameterMappingDefinition.getSource().getName())).collect(Collectors.toList());
            if (list.isEmpty()) {
                return "";
            }
            if (list.size() == 1) {
                return "Task Output: parameter " + ((ParameterMappingDefinition)list.get(0)).getTarget().getName() + " has no value, because raw parameter " + ((ParameterMappingDefinition)list.get(0)).getSource().getName() + " is missing";
            }
            List list2 = list.stream().map(parameterMappingDefinition -> parameterMappingDefinition.getSource().getName()).collect(Collectors.toList());
            List list3 = list.stream().map(parameterMappingDefinition -> parameterMappingDefinition.getTarget().getName()).collect(Collectors.toList());
            return "Task Output: parameters " + list3 + " have no value - missing raw output parameters " + list2;
        }, new Object[0]);
        this.addDebugInfo(() -> {
            List list = ((Map)valueMap2.getValue()).keySet().stream().filter(string -> collection.stream().noneMatch(parameterMappingDefinition -> parameterMappingDefinition.getSource().getName().equals(string))).collect(Collectors.toList());
            if (list.isEmpty()) {
                return "";
            }
            if (list.size() == 1) {
                return "Task Output: found parameter " + (String)list.get(0) + ", but it is not defined";
            }
            return "Task Output: found parameters " + list + ", but they are not defined";
        }, new Object[0]);
        ValueMap valueMap3 = new ValueMap();
        for (ParameterMappingDefinition parameterMappingDefinition : collection) {
            Value<?> value;
            if (parameterMappingDefinition.isInputParameterMapping()) continue;
            String string2 = parameterMappingDefinition.getSource().getName();
            String string3 = parameterMappingDefinition.getTarget().getName();
            if (valueMap2.has(string2)) {
                value = valueMap2.get(string2);
                Value<?> value2 = parameterMappingDefinition.transformOutput(this, value);
                valueMap3.put(string3, value2);
                continue;
            }
            if (!parameterMappingDefinition.hasTransformation() || Value.NULL.equals(value = parameterMappingDefinition.transformOutput(this, Value.NULL))) continue;
            valueMap3.put(string3, value);
        }
        if (bl) {
            Vector vector = new Vector();
            ((TaskDefinition)this.getDefinition()).getOutputParameters().forEach((string, taskOutputParameterDefinition) -> {
                Value<?> value = valueMap3.get(string);
                if (taskOutputParameterDefinition.isMandatory() && value.equals(Value.NULL)) {
                    vector.add("Task output parameter " + string + " does not have a value, but that is required in order to complete the task");
                }
                TaskOutputParameter taskOutputParameter = new TaskOutputParameter((TaskOutputParameterDefinition)taskOutputParameterDefinition, (Task<?>)this, value);
                try {
                    taskOutputParameter.validate();
                }
                catch (CaseFileError | TransitionDeniedException commandException) {
                    vector.add(commandException.getMessage());
                }
            });
            if (vector.size() > 0) {
                throw new InvalidCommandException(vector.toString());
            }
        }
        return valueMap3;
    }

    protected ValueMap getInputParameters() {
        return this.taskInput;
    }

    public ValueMap getMappedInputParameters() {
        return this.implementationInput;
    }

    @Override
    protected void dumpImplementationToXML(Element element) {
        super.dumpImplementationToXML(element);
        this.taskInput.fieldNames().forEachRemaining(string -> this.appendParameter((String)string, this.taskInput.get(string), element, "inputs"));
        this.taskOutput.fieldNames().forEachRemaining(string -> this.appendParameter((String)string, this.taskOutput.get(string), element, "outputs"));
    }

    private void appendParameter(String string, Value<?> value, Element element, String string2) {
        Element element2 = element.getOwnerDocument().createElement(string2);
        element.appendChild(element2);
        element2.setAttribute("name", string);
        Text text = element.getOwnerDocument().createTextNode(String.valueOf(value));
        element2.appendChild(text);
    }

    public void updateState(TaskInputFilled taskInputFilled) {
        this.taskInput = taskInputFilled.getTaskInputParameters();
        this.implementationInput = taskInputFilled.getMappedInputParameters();
    }

    public void updateState(TaskOutputFilled taskOutputFilled) {
        this.givenOutput = taskOutputFilled.getRawOutputParameters();
        this.taskOutput = taskOutputFilled.getTaskOutputParameters();
        if (this.getCaseInstance().recoveryRunning()) {
            return;
        }
        ((Map)this.taskOutput.getValue()).forEach((string, value) -> {
            TaskOutputParameterDefinition taskOutputParameterDefinition = ((TaskDefinition)this.getDefinition()).getOutputParameters().get(string);
            TaskOutputParameter taskOutputParameter = new TaskOutputParameter(taskOutputParameterDefinition, (Task<?>)this, (Value<?>)value);
            taskOutputParameter.bind();
        });
    }
}

