/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.time.Instant;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerCompleted;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerDropped;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerResumed;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerSet;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerSuspended;
import org.cafienne.cmmn.actorapi.event.plan.eventlistener.TimerTerminated;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.TimerEventDefinition;
import org.cafienne.cmmn.instance.EventListener;
import org.cafienne.cmmn.instance.Stage;

public class TimerEvent
extends EventListener<TimerEventDefinition> {
    private Instant targetMoment = null;

    public TimerEvent(String string, int n, ItemDefinition itemDefinition, TimerEventDefinition timerEventDefinition, Stage<?> stage) {
        super(string, n, itemDefinition, timerEventDefinition, stage);
    }

    public void updateState(TimerSet timerSet) {
        this.targetMoment = timerSet.getTargetMoment();
        this.addDebugInfo(() -> super.toString() + " occurs at " + this.targetMoment, new Object[0]);
    }

    @Override
    protected void createInstance() {
        this.addEvent(new TimerSet(this));
    }

    @Override
    protected void completeInstance() {
        this.addEvent(new TimerCompleted(this));
    }

    @Override
    protected void suspendInstance() {
        this.addEvent(new TimerSuspended(this));
    }

    @Override
    protected void resumeInstance() {
        this.addEvent(new TimerResumed(this));
    }

    @Override
    protected void terminateInstance() {
        this.addEvent(new TimerTerminated(this));
    }

    @Override
    protected void lostDefinition() {
        super.lostDefinition();
        this.addEvent(new TimerDropped(this));
    }
}

