/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance;

import java.util.Collection;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.cmmn.actorapi.command.team.CurrentMember;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.UserEventDefinition;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.instance.EventListener;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.Transition;
import org.w3c.dom.Element;

public class UserEvent
extends EventListener<UserEventDefinition> {
    public UserEvent(String string, int n, ItemDefinition itemDefinition, UserEventDefinition userEventDefinition, Stage<?> stage) {
        super(string, n, itemDefinition, userEventDefinition, stage);
    }

    public Collection<CaseRoleDefinition> getAuthorizedRoles() {
        return ((UserEventDefinition)this.getDefinition()).getAuthorizedRoles();
    }

    @Override
    public void validateTransition(Transition transition) {
        super.validateTransition(transition);
        if (transition != Transition.Occur) {
            return;
        }
        CurrentMember currentMember = this.getCaseInstance().getCurrentTeamMember();
        if (!currentMember.hasRoles(this.getAuthorizedRoles())) {
            throw new AuthorizationException("User '" + currentMember.userId() + "' does not have the permission to raise the event " + this.getName());
        }
    }

    @Override
    protected void dumpImplementationToXML(Element element) {
        super.dumpImplementationToXML(element);
        Collection<CaseRoleDefinition> collection = this.getAuthorizedRoles();
        for (CaseRoleDefinition caseRoleDefinition : collection) {
            String string = caseRoleDefinition.getName();
            Element element2 = element.getOwnerDocument().createElement("Role");
            element.appendChild(element2);
            element2.setAttribute("name", string);
        }
    }
}

