/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.parameter;

import org.cafienne.cmmn.definition.casefile.CaseFileItemDefinition;
import org.cafienne.cmmn.definition.parameter.BindingOperation;
import org.cafienne.cmmn.definition.parameter.BindingRefinementDefinition;
import org.cafienne.cmmn.definition.parameter.TaskOutputParameterDefinition;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.TransitionDeniedException;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.parameter.TaskParameter;
import org.cafienne.json.Value;

public class TaskOutputParameter
extends TaskParameter<TaskOutputParameterDefinition> {
    public TaskOutputParameter(TaskOutputParameterDefinition taskOutputParameterDefinition, Task<?> task, Value<?> value) {
        super(taskOutputParameterDefinition, task, value);
    }

    public void validate() {
        if (!this.hasBinding()) {
            this.addDebugInfo(() -> "Parameter '" + this.getName() + "' has no case file binding binding", new Object[0]);
            return;
        }
        CaseFileItem caseFileItem = (CaseFileItem)this.getBinding().getPath().resolve(this.getCaseInstance());
        this.addDebugInfo(() -> "Validating property types of a " + caseFileItem.getName() + " against value ", this.value);
        ((CaseFileItemDefinition)caseFileItem.getDefinition()).validatePropertyTypes(this.value);
        if (caseFileItem.getState() == State.Discarded) {
            this.addDebugInfo(() -> "Cannot bind parameter '" + ((TaskOutputParameterDefinition)this.getDefinition()).getName() + "' to CaseFileItem[" + caseFileItem.getPath() + "], since the item is in state Discarded", new Object[0]);
            throw new TransitionDeniedException("Cannot bind parameter value, because case file item has been deleted");
        }
    }

    public void bind() {
        if (!this.hasBinding()) {
            return;
        }
        CaseFileItem caseFileItem = (CaseFileItem)this.getBinding().getPath().resolve(this.getCaseInstance());
        block0 : switch (caseFileItem.getState()) {
            case Discarded: {
                this.addDebugInfo(() -> "Cannot bind parameter '" + ((TaskOutputParameterDefinition)this.getDefinition()).getName() + "' to CaseFileItem[" + caseFileItem.getPath() + "], since the item is in state Discarded", new Object[0]);
                return;
            }
            case Null: {
                this.addDebugInfo(() -> "Binding parameter '" + ((TaskOutputParameterDefinition)this.getDefinition()).getName() + "' to CaseFileItem[" + caseFileItem.getPath() + "] will create new content (transition -> Create)", new Object[0]);
                caseFileItem.createContent(this.value);
                break;
            }
            case Available: {
                BindingRefinementDefinition bindingRefinementDefinition = ((TaskOutputParameterDefinition)this.getDefinition()).getBindingRefinement();
                BindingOperation bindingOperation = bindingRefinementDefinition != null ? bindingRefinementDefinition.getRefinementOperation() : (caseFileItem.isArray() ? BindingOperation.Add : BindingOperation.Update);
                this.addDebugInfo(() -> {
                    if (bindingRefinementDefinition == null || bindingOperation == BindingOperation.None) {
                        return "Binding parameter '" + ((TaskOutputParameterDefinition)this.getDefinition()).getName() + "' to CaseFileItem[" + caseFileItem.getPath() + "] is done with default operation " + bindingOperation;
                    }
                    return "Binding parameter '" + ((TaskOutputParameterDefinition)this.getDefinition()).getName() + "' to CaseFileItem[" + caseFileItem.getPath() + "] is done with operation " + bindingOperation;
                }, new Object[0]);
                switch (bindingOperation) {
                    case Add: {
                        if (caseFileItem.isArray()) {
                            caseFileItem.createContent(this.value);
                            break block0;
                        }
                        this.addDebugInfo(() -> "Unexpected task output operation '" + bindingOperation + "' on value of parameter '" + ((TaskOutputParameterDefinition)this.getDefinition()).getName() + "' because case file item already exists; updating content instead", new Object[0]);
                        caseFileItem.updateContent(this.value);
                        break block0;
                    }
                    case Replace: {
                        caseFileItem.replaceContent(this.value);
                        break block0;
                    }
                    case Update: {
                        caseFileItem.updateContent(this.value);
                        break block0;
                    }
                    case ReplaceIndexed: {
                        if (caseFileItem.isArray()) {
                            caseFileItem.getArrayElement(this.task.getRepeatIndex()).replaceContent(this.value);
                            break block0;
                        }
                        this.addDebugInfo(() -> "Unexpected task output operation '" + bindingOperation + "' on value of parameter '" + ((TaskOutputParameterDefinition)this.getDefinition()).getName() + "' because case file item already exists; updating content instead", new Object[0]);
                        caseFileItem.replaceContent(this.value);
                        break block0;
                    }
                    case UpdateIndexed: {
                        if (caseFileItem.isArray()) {
                            caseFileItem.getArrayElement(this.task.getRepeatIndex()).updateContent(this.value);
                            break block0;
                        }
                        this.addDebugInfo(() -> "Unexpected task output operation '" + bindingOperation + "' on value of parameter '" + ((TaskOutputParameterDefinition)this.getDefinition()).getName() + "' because case file item already exists; updating content instead", new Object[0]);
                        caseFileItem.updateContent(this.value);
                    }
                }
            }
        }
    }
}

