/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.sentry;

import org.cafienne.cmmn.actorapi.event.file.CaseFileItemTransitioned;
import org.cafienne.cmmn.definition.sentry.CaseFileItemOnPartDefinition;
import org.cafienne.cmmn.instance.casefile.CaseFileItem;
import org.cafienne.cmmn.instance.casefile.CaseFileItemTransition;
import org.cafienne.cmmn.instance.sentry.Criterion;
import org.cafienne.cmmn.instance.sentry.OnPart;
import org.cafienne.json.ValueMap;
import org.w3c.dom.Element;

public class CaseFileItemOnPart
extends OnPart<CaseFileItemOnPartDefinition, CaseFileItemTransitioned, CaseFileItem> {
    private boolean isActive;
    private CaseFileItemTransitioned lastEvent;

    public CaseFileItemOnPart(Criterion<?> criterion, CaseFileItemOnPartDefinition caseFileItemOnPartDefinition) {
        super(criterion, caseFileItemOnPartDefinition);
    }

    CaseFileItemTransition getStandardEvent() {
        return ((CaseFileItemOnPartDefinition)this.getDefinition()).getStandardEvent();
    }

    @Override
    void connectToCase() {
        CaseFileItem caseFileItem = (CaseFileItem)((CaseFileItemOnPartDefinition)this.getDefinition()).getSourceDefinition().getPath().resolve(this.getCaseInstance());
        this.establishPotentialConnection(caseFileItem);
    }

    @Override
    public void releaseFromCase() {
        this.connectedItems.forEach(caseFileItem -> caseFileItem.releaseOnPart(this));
    }

    @Override
    protected void establishPotentialConnection(CaseFileItem caseFileItem) {
        if (this.connectedItems.contains(caseFileItem)) {
            return;
        }
        if (!((CaseFileItemOnPartDefinition)this.getDefinition()).getSourceDefinition().equals(caseFileItem.getDefinition())) {
            return;
        }
        this.addDebugInfo(() -> "Connecting case file item " + caseFileItem + " to " + this.criterion, new Object[0]);
        this.connectedItems.add(caseFileItem);
        caseFileItem.connectOnPart(this);
    }

    @Override
    protected void removeConnection(CaseFileItem caseFileItem) {
        this.connectedItems.remove(caseFileItem);
    }

    @Override
    public void inform(CaseFileItem caseFileItem, CaseFileItemTransitioned caseFileItemTransitioned) {
        this.addDebugInfo(() -> "Case file item " + caseFileItem.getPath() + " informs " + this.criterion + " about transition " + caseFileItemTransitioned.getTransition() + ".", new Object[0]);
        this.lastEvent = caseFileItemTransitioned;
        this.isActive = this.getStandardEvent().equals((Object)caseFileItemTransitioned.getTransition());
        if (this.isActive) {
            this.criterion.activate(this);
        } else {
            this.criterion.deactivate(this);
        }
    }

    @Override
    ValueMap toJson() {
        return new ValueMap(new Object[]{"casefile-item", this.getSourceName(), "active", this.isActive, "awaiting-transition", this.getStandardEvent(), "last-found-transition", "" + this.lastEvent});
    }

    @Override
    void dumpMemoryStateToXML(Element element, boolean bl) {
        Element element2 = element.getOwnerDocument().createElement("onPart");
        element.appendChild(element2);
        element2.setAttribute("active", "" + this.isActive);
        element2.setAttribute("source", this.getSourceName() + "." + this.getStandardEvent());
        element2.setAttribute("last", "" + this.lastEvent);
        if (bl) {
            for (CaseFileItem caseFileItem : this.connectedItems) {
                String string = caseFileItem.getName() + "." + caseFileItem.getLastTransition();
                Element element3 = element.getOwnerDocument().createElement("caseFileItem");
                element3.setAttribute("last", string);
                element3.setAttribute("name", caseFileItem.getName());
                element2.appendChild(element3);
            }
        }
    }
}

