/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.sentry;

import java.util.ArrayList;
import java.util.List;
import org.cafienne.cmmn.instance.sentry.SentryNetwork;
import org.cafienne.cmmn.instance.sentry.StandardEvent;
import org.cafienne.infrastructure.enginedeveloper.EngineDeveloperConsole;

class TransitionCallStack {
    private final SentryNetwork handler;
    private Frame currentFrame = null;

    TransitionCallStack(SentryNetwork sentryNetwork) {
        this.handler = sentryNetwork;
    }

    void pushEvent(StandardEvent standardEvent) {
        if (standardEvent.hasBehavior()) {
            Frame frame = new Frame(standardEvent, this.currentFrame);
            frame.invokeImmediateBehavior();
            frame.postponeDelayedBehavior();
        }
    }

    private class Frame {
        private final StandardEvent event;
        private final Frame parent;
        private final List<Frame> children = new ArrayList<Frame>();
        private final int depth;

        Frame(StandardEvent standardEvent, Frame frame) {
            this.event = standardEvent;
            this.parent = frame;
            this.depth = frame == null ? 1 : frame.depth + 1;
        }

        private String print(String string) {
            return string + " for " + this.event.getSource().getDescription() + "." + this.event.getTransition();
        }

        private void postponeDelayedBehavior() {
            if (TransitionCallStack.this.currentFrame == null) {
                this.invokeDelayedBehavior();
            } else {
                TransitionCallStack.this.currentFrame.children.add(0, this);
                if (EngineDeveloperConsole.enabled()) {
                    EngineDeveloperConsole.debugIndentedConsoleLogging(this.print("* postponing delayed behavior"));
                    EngineDeveloperConsole.indent(2);
                    TransitionCallStack.this.currentFrame.children.forEach(frame -> EngineDeveloperConsole.debugIndentedConsoleLogging("- " + frame.event.getDescription()));
                    EngineDeveloperConsole.outdent(2);
                }
            }
        }

        void invokeImmediateBehavior() {
            EngineDeveloperConsole.indent(2);
            Frame frame = TransitionCallStack.this.currentFrame;
            TransitionCallStack.this.currentFrame = this;
            if (EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging("\n-------- " + this + this.print("Running immmediate behavior"));
            }
            EngineDeveloperConsole.indent(1);
            this.event.runImmediateBehavior();
            EngineDeveloperConsole.outdent(1);
            if (EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging("-------- " + this + this.print("Finished immmediate behavior") + "\n");
            }
            EngineDeveloperConsole.outdent(2);
            TransitionCallStack.this.currentFrame = frame;
        }

        void invokeDelayedBehavior() {
            Frame frame2 = TransitionCallStack.this.currentFrame;
            TransitionCallStack.this.currentFrame = this;
            EngineDeveloperConsole.indent(2);
            if (EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging("\n******** " + this + this.print("Running delayed behavior"));
            }
            EngineDeveloperConsole.indent(1);
            this.event.runDelayedBehavior();
            if (this.children.size() > 0 && EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging(this + "Loading " + this.children.size() + " nested frames at level [" + (this.depth + 1) + "] as a consequence of " + this.event.getDescription());
            }
            this.children.forEach(frame -> frame.invokeDelayedBehavior());
            EngineDeveloperConsole.outdent(1);
            if (EngineDeveloperConsole.enabled()) {
                EngineDeveloperConsole.debugIndentedConsoleLogging("******** " + this + this.print("Completed delayed behavior"));
            }
            EngineDeveloperConsole.outdent(2);
            TransitionCallStack.this.currentFrame = frame2;
        }

        public String toString() {
            return "StackFrame[" + this.depth + "]: ";
        }
    }
}

