/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.task.cmmn;

import org.cafienne.actormodel.response.CommandResponseListener;
import org.cafienne.cmmn.actorapi.command.StartCase;
import org.cafienne.cmmn.actorapi.command.migration.MigrateDefinition;
import org.cafienne.cmmn.actorapi.command.plan.MakeCaseTransition;
import org.cafienne.cmmn.actorapi.command.team.CaseTeam;
import org.cafienne.cmmn.definition.CaseDefinition;
import org.cafienne.cmmn.definition.CaseTaskDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.json.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseTask
extends Task<CaseTaskDefinition> {
    private static final Logger logger = LoggerFactory.getLogger(CaseTask.class);
    private final String subCaseId = this.getId();
    private final Case mainCase = this.getCaseInstance();

    public CaseTask(String string, int n, ItemDefinition itemDefinition, CaseTaskDefinition caseTaskDefinition, Stage<?> stage) {
        super(string, n, itemDefinition, caseTaskDefinition, stage);
    }

    @Override
    protected void terminateInstance() {
        if (this.getHistoryState() == State.Available) {
            this.addDebugInfo(() -> "Terminating human task '" + this.getName() + "' without it being started; no need to inform the task actor", new Object[0]);
        } else {
            this.tell(Transition.Terminate);
        }
    }

    @Override
    protected void suspendInstance() {
        this.tell(Transition.Suspend);
    }

    @Override
    protected void resumeInstance() {
        this.tell(Transition.Reactivate);
    }

    @Override
    protected void reactivateImplementation(ValueMap valueMap) {
        this.startImplementation(valueMap);
    }

    @Override
    protected void startImplementation(ValueMap valueMap) {
        CaseDefinition caseDefinition = ((CaseTaskDefinition)this.getDefinition()).getImplementationDefinition();
        String string = this.mainCase.getId();
        String string2 = this.mainCase.getRootCaseId();
        ValueMap valueMap2 = this.getMappedInputParameters();
        CaseTeam caseTeam = this.mainCase.getCaseTeam().createSubCaseTeam(caseDefinition);
        StartCase startCase = new StartCase(this.getCaseInstance().getTenant(), this.getCaseInstance().getCurrentUser(), this.subCaseId, caseDefinition, valueMap2, caseTeam, this.getCaseInstance().debugMode(), string, string2);
        this.getCaseInstance().askCase(startCase, commandFailure -> this.goFault(new ValueMap("failure", commandFailure.toJson())), modelResponse -> {
            if (!((CaseTaskDefinition)this.getDefinition()).isBlocking()) {
                this.makeTransition(Transition.Complete);
            }
        });
    }

    private void tell(Transition transition) {
        if (((CaseTaskDefinition)this.getDefinition()).isBlocking()) {
            MakeCaseTransition makeCaseTransition = new MakeCaseTransition(this.getCaseInstance().getCurrentUser(), this.subCaseId, transition);
            this.getCaseInstance().askCase(makeCaseTransition, commandFailure -> logger.error("Could not make transition " + transition + " on sub case implementation for task " + this.subCaseId + "\n" + commandFailure), new CommandResponseListener[0]);
        }
    }

    @Override
    public void migrateItemDefinition(ItemDefinition itemDefinition, CaseTaskDefinition caseTaskDefinition) {
        super.migrateItemDefinition(itemDefinition, caseTaskDefinition);
        if (this.getState() != State.Null && this.getState() != State.Available) {
            this.addDebugInfo(() -> this + ": telling sub case with id " + this.getId() + " to migrate it's definition", new Object[0]);
            CaseDefinition caseDefinition = caseTaskDefinition.getImplementationDefinition();
            this.getCaseInstance().askCase(new MigrateDefinition(this.getCaseInstance().getCurrentUser(), this.getId(), caseDefinition), commandFailure -> logger.error("Failure while migrating definition of case task " + this.getDescription() + ": " + commandFailure.toJson()), new CommandResponseListener[0]);
        }
    }

    @Override
    protected void lostDefinition() {
        this.addDebugInfo(() -> "Dropping CaseTasks through migration is not possible. Task[" + this.getPath() + "] remains in the case with current state '" + this.getState() + "'", new Object[0]);
    }
}

