/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.instance.task.humantask;

import java.util.Collection;
import org.cafienne.cmmn.actorapi.event.CaseAppliedPlatformUpdate;
import org.cafienne.cmmn.definition.HumanTaskDefinition;
import org.cafienne.cmmn.definition.ItemDefinition;
import org.cafienne.cmmn.definition.PlanningTableDefinition;
import org.cafienne.cmmn.definition.task.validation.TaskOutputValidatorDefinition;
import org.cafienne.cmmn.definition.team.CaseRoleDefinition;
import org.cafienne.cmmn.instance.DiscretionaryItem;
import org.cafienne.cmmn.instance.Stage;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.Task;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.instance.TransitionDeniedException;
import org.cafienne.cmmn.instance.task.validation.TaskOutputValidator;
import org.cafienne.cmmn.instance.task.validation.ValidationResponse;
import org.cafienne.humantask.actorapi.event.HumanTaskResumed;
import org.cafienne.humantask.actorapi.event.HumanTaskSuspended;
import org.cafienne.humantask.actorapi.event.HumanTaskTerminated;
import org.cafienne.humantask.actorapi.event.migration.HumanTaskDropped;
import org.cafienne.humantask.instance.WorkflowTask;
import org.cafienne.json.ValueMap;
import org.w3c.dom.Element;

public class HumanTask
extends Task<HumanTaskDefinition> {
    private WorkflowTask workflow;

    public HumanTask(String string, int n, ItemDefinition itemDefinition, HumanTaskDefinition humanTaskDefinition, Stage<?> stage) {
        super(string, n, itemDefinition, humanTaskDefinition, stage);
    }

    public WorkflowTask getImplementation() {
        if (this.workflow == null) {
            this.workflow = ((HumanTaskDefinition)this.getDefinition()).getImplementationDefinition().createInstance(this);
        }
        return this.workflow;
    }

    @Override
    public boolean makeTransition(Transition transition) {
        if (transition == Transition.Complete && this.getState() == State.Active) {
            return this.workflow.complete(new ValueMap());
        }
        return super.makeTransition(transition);
    }

    @Override
    public ValidationResponse validateOutput(ValueMap valueMap) {
        TaskOutputValidatorDefinition taskOutputValidatorDefinition = ((HumanTaskDefinition)this.getDefinition()).getTaskOutputValidator();
        if (taskOutputValidatorDefinition != null) {
            TaskOutputValidator taskOutputValidator = taskOutputValidatorDefinition.createInstance(this);
            ValidationResponse validationResponse = taskOutputValidator.validate(valueMap);
            if (!validationResponse.isValid()) {
                this.addDebugInfo(() -> "Output validation for task " + this.getName() + "[" + this.getId() + "] failed with ", validationResponse.getContent());
            } else {
                this.addDebugInfo(() -> "Output validation for task " + this.getName() + "[" + this.getId() + "] succeeded with ", validationResponse.getContent());
            }
            return validationResponse;
        }
        return super.validateOutput(valueMap);
    }

    @Override
    protected void startImplementation(ValueMap valueMap) {
        this.getImplementation().beginLifeCycle();
    }

    @Override
    protected void terminateInstance() {
        if (this.getHistoryState() == State.Available) {
            this.addDebugInfo(() -> "Terminating human task '" + this.getName() + "' without it being started; no need to inform the task actor", new Object[0]);
        } else {
            this.addEvent(new HumanTaskTerminated(this));
        }
    }

    @Override
    protected void suspendInstance() {
        this.addEvent(new HumanTaskSuspended(this));
    }

    @Override
    protected void resumeInstance() {
        this.addEvent(new HumanTaskResumed(this));
    }

    @Override
    protected void reactivateImplementation(ValueMap valueMap) {
        this.startImplementation(valueMap);
    }

    @Override
    protected boolean hasDiscretionaryItems() {
        PlanningTableDefinition planningTableDefinition = ((HumanTaskDefinition)this.getDefinition()).getPlanningTable();
        if (planningTableDefinition != null) {
            return planningTableDefinition.hasItems(this);
        }
        return false;
    }

    @Override
    protected void retrieveDiscretionaryItems(Collection<DiscretionaryItem> collection) {
        PlanningTableDefinition planningTableDefinition = ((HumanTaskDefinition)this.getDefinition()).getPlanningTable();
        if (planningTableDefinition != null) {
            this.addDebugInfo(() -> "Iterating planning table items in " + this, new Object[0]);
            planningTableDefinition.evaluate(this, collection);
        }
    }

    public CaseRoleDefinition getPerformer() {
        return ((HumanTaskDefinition)this.getDefinition()).getPerformer();
    }

    @Override
    public void validateTransition(Transition transition) {
        super.validateTransition(transition);
        if (transition == Transition.Complete && !this.currentUserIsAuthorized()) {
            throw new TransitionDeniedException("You do not have the permission to perform the task " + this.getName());
        }
    }

    public boolean currentUserIsAuthorized() {
        return this.getCaseInstance().getCurrentTeamMember().hasRole(this.getPerformer());
    }

    @Override
    protected void dumpImplementationToXML(Element element) {
        super.dumpImplementationToXML(element);
        CaseRoleDefinition caseRoleDefinition = this.getPerformer();
        if (caseRoleDefinition != null) {
            String string = caseRoleDefinition.getName();
            Element element2 = element.getOwnerDocument().createElement("Role");
            element.appendChild(element2);
            element2.setAttribute("name", string);
        }
    }

    @Override
    public void updateState(CaseAppliedPlatformUpdate caseAppliedPlatformUpdate) {
        this.getImplementation().updateState(caseAppliedPlatformUpdate);
    }

    @Override
    public void migrateItemDefinition(ItemDefinition itemDefinition, HumanTaskDefinition humanTaskDefinition) {
        super.migrateItemDefinition(itemDefinition, humanTaskDefinition);
        this.getImplementation().migrateDefinition(humanTaskDefinition.getImplementationDefinition());
    }

    @Override
    protected void lostDefinition() {
        super.lostDefinition();
        this.addEvent(new HumanTaskDropped(this));
    }
}

