/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.repository.file;

import java.util.LinkedHashMap;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SimpleLRUCache<K, T>
extends LinkedHashMap<K, T> {
    private static final Logger logger = LoggerFactory.getLogger(SimpleLRUCache.class);
    private final int maxSize;

    public SimpleLRUCache(int n) {
        super(n >= 0 ? n : 0, 0.75f, true);
        this.maxSize = n;
    }

    @Override
    public T put(K k, T t) {
        if (this.maxSize >= 0) {
            return super.put(k, t);
        }
        return null;
    }

    @Override
    protected boolean removeEldestEntry(Map.Entry<K, T> entry) {
        boolean bl;
        boolean bl2 = bl = this.size() > this.maxSize;
        if (bl) {
            logger.debug("Removing " + entry.getClass().getSimpleName() + " " + entry.getKey() + " from the cache, since max cache size " + this.maxSize + " has been reached.");
        }
        return bl;
    }
}

