/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test;

import akka.actor.ActorRef;
import akka.actor.ActorSystem;
import akka.actor.Props;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import org.cafienne.actormodel.command.ModelCommand;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.cmmn.actorapi.event.CaseModified;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemCreated;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemEvent;
import org.cafienne.cmmn.actorapi.event.plan.PlanItemTransitioned;
import org.cafienne.cmmn.actorapi.event.plan.task.TaskEvent;
import org.cafienne.cmmn.actorapi.event.plan.task.TaskInputFilled;
import org.cafienne.cmmn.actorapi.event.plan.task.TaskOutputFilled;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.Transition;
import org.cafienne.cmmn.test.CaseEventPublisher;
import org.cafienne.cmmn.test.ResponseHandlingActor;
import org.cafienne.cmmn.test.TestScript;
import org.cafienne.cmmn.test.assertions.PublishedEventsAssertion;
import org.cafienne.cmmn.test.filter.EventFilter;
import org.cafienne.system.router.CafienneGateway;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CaseEventListener {
    private static final Logger logger = LoggerFactory.getLogger(CaseEventListener.class);
    private final List<ModelEvent> publishedEvents = new ArrayList<ModelEvent>();
    private List<ModelEvent> newEvents = new ArrayList<ModelEvent>();
    private CaseModified lastCaseModifiedEvent;
    private final CafienneGateway caseMessageRouter;
    private final ActorRef responseHandlingActor;
    private final TestScript testScript;
    private final CaseEventPublisher readJournal;

    CaseEventListener(TestScript testScript) {
        this.testScript = testScript;
        this.caseMessageRouter = testScript.getCaseSystem().gateway();
        ActorSystem actorSystem = testScript.getCaseSystem().system();
        this.responseHandlingActor = actorSystem.actorOf(Props.create(ResponseHandlingActor.class, (Object[])new Object[]{this.testScript}));
        this.readJournal = new CaseEventPublisher(this, testScript.getCaseSystem());
    }

    void sendCommand(ModelCommand modelCommand) {
        this.newEvents = new ArrayList<ModelEvent>();
        this.caseMessageRouter.inform(modelCommand, this.responseHandlingActor);
    }

    void handle(Object object) {
        if (object instanceof ModelEvent) {
            if (object instanceof CaseModified) {
                this.lastCaseModifiedEvent = (CaseModified)object;
            }
            this.handle((ModelEvent)object);
        } else {
            logger.warn("Received unexpected event " + object);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void handle(ModelEvent modelEvent) {
        logger.debug("Received " + modelEvent.getClass().getSimpleName() + " event " + modelEvent);
        this.publishedEvents.add(modelEvent);
        this.newEvents.add(modelEvent);
        CaseEventListener caseEventListener = this;
        synchronized (caseEventListener) {
            this.notifyAll();
        }
    }

    public PublishedEventsAssertion<?> getNewEvents() {
        return new PublishedEventsAssertion<ModelEvent>(new ArrayList<ModelEvent>(this.newEvents));
    }

    public PublishedEventsAssertion getEvents() {
        return new PublishedEventsAssertion<ModelEvent>(new ArrayList<ModelEvent>(this.publishedEvents));
    }

    public CaseModified awaitCaseModifiedEvent(Instant instant) {
        if (this.lastCaseModifiedEvent != null && instant.equals(this.lastCaseModifiedEvent.lastModified())) {
            return this.lastCaseModifiedEvent;
        }
        return this.waitUntil("CaseModified-" + instant, CaseModified.class, caseModified -> instant.equals(caseModified.lastModified()), new long[0]);
    }

    public CaseModified awaitTaskModified(Instant instant) {
        return this.waitUntil("TaskModified-" + instant, CaseModified.class, caseModified -> instant.equals(caseModified.lastModified()), new long[0]);
    }

    public <T extends PlanItemEvent> T awaitPlanItemEvent(String string, Class<T> clazz, EventFilter<T> eventFilter, long ... lArray) {
        return (T)this.waitUntil("PlanItemEvent-" + string, clazz, planItemEvent -> {
            if (planItemEvent.getPlanItemId().equals(string)) {
                logger.debug("Matching event for plan item " + string + " of type " + planItemEvent.getType() + " for filter. Event " + planItemEvent);
            }
            return (planItemEvent.getPlanItemId().equals(string) || this.hasPlanItemName(planItemEvent.getPlanItemId(), string)) && eventFilter.matches(planItemEvent);
        }, lArray);
    }

    private <T extends TaskEvent> T awaitTaskEvent(String string, Class<T> clazz, EventFilter<T> eventFilter, long ... lArray) {
        return (T)this.waitUntil("TaskEvent-" + string, clazz, taskEvent -> {
            if (taskEvent.getTaskId().equals(string) || this.hasPlanItemName(taskEvent.getTaskId(), string)) {
                logger.debug("Receiving event " + taskEvent);
            }
            return (taskEvent.getTaskId().equals(string) || this.hasPlanItemName(taskEvent.getTaskId(), string)) && eventFilter.matches(taskEvent);
        }, lArray);
    }

    public boolean hasPlanItemName(String string, String string2) {
        long l = this.getEvents().filter(modelEvent -> modelEvent instanceof PlanItemCreated).filter(modelEvent -> ((PlanItemCreated)modelEvent).getPlanItemId().equals(string)).filter(modelEvent -> ((PlanItemCreated)modelEvent).getPlanItemName().equals(string2)).getEvents().size();
        return l > 0L;
    }

    public PlanItemTransitioned awaitPlanItemState(String string, State state, long ... lArray) {
        return this.awaitPlanItemTransitioned(string, planItemTransitioned -> planItemTransitioned.getCurrentState().equals((Object)state), lArray);
    }

    public PlanItemTransitioned awaitPlanItemState(String string, Transition transition, State state, State state2, long ... lArray) {
        return this.awaitPlanItemTransitioned(string, planItemTransitioned -> planItemTransitioned.getCurrentState().equals((Object)state) && planItemTransitioned.getTransition().equals((Object)transition) && planItemTransitioned.getHistoryState().equals((Object)state2), lArray);
    }

    public PlanItemTransitioned awaitPlanItemTransitioned(String string, EventFilter<PlanItemTransitioned> eventFilter, long ... lArray) {
        return this.awaitPlanItemEvent(string, PlanItemTransitioned.class, eventFilter, lArray);
    }

    public TaskInputFilled awaitTaskInputFilled(String string, EventFilter<TaskInputFilled> eventFilter, long ... lArray) {
        return this.awaitTaskEvent(string, TaskInputFilled.class, eventFilter, lArray);
    }

    public TaskOutputFilled awaitTaskOutputFilled(String string, EventFilter<TaskOutputFilled> eventFilter, long ... lArray) {
        return this.awaitTaskEvent(string, TaskOutputFilled.class, eventFilter, lArray);
    }

    public <T extends ModelEvent> T waitUntil(Class<T> clazz, EventFilter<T> eventFilter, long ... lArray) {
        return this.waitUntil("", clazz, eventFilter, lArray);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public <T extends ModelEvent> T waitUntil(String string, Class<T> clazz, EventFilter<T> eventFilter, long ... lArray) {
        long l;
        long l2 = l = lArray.length >= 1 ? lArray[0] : 10000L;
        long l3 = l2 / 1000L;
        long l4 = System.currentTimeMillis();
        CaseEventListener caseEventListener = this;
        synchronized (caseEventListener) {
            int n = this.publishedEvents.size();
            for (int i = 0; i < n; ++i) {
                ModelEvent modelEvent = this.publishedEvents.get(i);
                if (!this.filterMatches(clazz, eventFilter, modelEvent)) continue;
                return (T)modelEvent;
            }
            try {
                while (true) {
                    this.wait(1000L);
                    long l5 = System.currentTimeMillis();
                    l2 = l - (l5 - l4);
                    int n2 = this.publishedEvents.size();
                    for (int i = n; i < n2; ++i) {
                        ModelEvent modelEvent = this.publishedEvents.get(i);
                        if (!this.filterMatches(clazz, eventFilter, modelEvent)) continue;
                        return (T)modelEvent;
                    }
                    n = n2;
                    if (l5 - l4 > l) {
                        throw new AssertionError((Object)("Events have not come after waiting for more than " + l / 1000L + " seconds"));
                    }
                    if (l3 == l2 / 1000L) continue;
                    l3 = l2 / 1000L;
                    logger.warn("Waiting " + l3 + " seconds for match " + string + " on filter " + eventFilter);
                }
            }
            catch (InterruptedException interruptedException) {
                logger.warn("Breaking out with interrupted exception", (Throwable)interruptedException);
            }
        }
        return null;
    }

    private <T extends ModelEvent> boolean filterMatches(Class<T> clazz, EventFilter<T> eventFilter, ModelEvent modelEvent) {
        return clazz.isAssignableFrom(modelEvent.getClass()) && eventFilter.matches(modelEvent);
    }
}

