/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test;

import org.cafienne.actormodel.ModelActor;
import org.cafienne.actormodel.command.BaseModelCommand;
import org.cafienne.actormodel.command.BootstrapMessage;
import org.cafienne.actormodel.identity.CaseUserIdentity;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.actormodel.response.ModelResponse;
import org.cafienne.cmmn.actorapi.command.CaseCommand;
import org.cafienne.cmmn.actorapi.response.CaseResponse;
import org.cafienne.cmmn.instance.Case;
import org.cafienne.cmmn.test.CaseEventListener;
import org.cafienne.cmmn.test.CaseResponseValidator;
import org.cafienne.cmmn.test.TestScript;
import org.cafienne.cmmn.test.TestScriptCommand;
import org.cafienne.cmmn.test.assertions.PublishedEventsAssertion;
import org.cafienne.infrastructure.serialization.Manifest;
import org.cafienne.json.Value;
import org.cafienne.json.ValueMap;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@Manifest
public class CaseTestCommand
extends CaseCommand
implements BootstrapMessage {
    private static final Logger logger = LoggerFactory.getLogger(CaseTestCommand.class);
    private final transient TestScript testScript;
    private final transient CaseResponseValidator validator;
    private final CaseCommand actualCommand;
    private CaseResponse actualResponse;
    private CommandFailure actualFailure;
    @Deprecated
    private String caseSnapshotString = "No case available";

    CaseTestCommand(TestScript testScript, CaseCommand caseCommand, CaseResponseValidator caseResponseValidator) {
        super((CaseUserIdentity)caseCommand.getUser(), caseCommand.getCaseInstanceId());
        this.testScript = testScript;
        this.actualCommand = caseCommand;
        this.validator = caseResponseValidator;
    }

    public CaseTestCommand(ValueMap valueMap) {
        super(valueMap);
        this.testScript = null;
        this.validator = null;
        this.actualCommand = null;
    }

    @Override
    public boolean isBootstrapMessage() {
        return this.actualCommand.isBootstrapMessage();
    }

    public int getActionNumber() {
        return this.testScript.getActionNumber();
    }

    public <T extends CaseCommand> T getActualCommand() {
        return (T)this.actualCommand;
    }

    boolean isTestScriptCommand() {
        return this.actualCommand instanceof TestScriptCommand;
    }

    @Override
    public void validate(Case case_) {
        this.actualCommand.setActor((ModelActor)((Object)this.getActor()));
        this.caseSnapshotString = case_.stateToXMLString();
        this.actualCommand.validate(case_);
        this.caseSnapshotString = case_.stateToXMLString();
    }

    @Override
    public ModelResponse process(Case case_) {
        ModelResponse modelResponse = this.actualCommand.process(case_);
        this.caseSnapshotString = case_.stateToXMLString();
        return modelResponse;
    }

    public <R extends CaseResponse> R getActualResponse() {
        return (R)this.actualResponse;
    }

    public CommandFailure getActualFailure() {
        return this.actualFailure;
    }

    public CaseEventListener getEventListener() {
        return this.testScript.getEventListener();
    }

    @Override
    public String getCommandDescription() {
        return "CaseTestCommand[" + ((BaseModelCommand)this.getActualCommand()).getCommandDescription() + "]";
    }

    @Override
    public String toString() {
        return "Test command " + this.getActionNumber() + " of type " + this.getActualCommand().getClass().getSimpleName() + " resulted in " + this.getEvents().getEvents().size() + " events";
    }

    public PublishedEventsAssertion<?> getEvents() {
        return this.getEventListener().getNewEvents().filter(this.getActorId());
    }

    public void handleResponse(CaseResponse caseResponse) {
        this.actualResponse = caseResponse;
        this.awaitCaseModifiedEvent(caseResponse);
        this.runValidation();
    }

    void runValidation() {
        if (this.validator != null) {
            logger.debug("Validating response for test command " + this.getActionNumber() + ": " + this.getActualCommand());
            this.validator.validate(this);
        } else {
            logger.debug("Did not find validations for test command " + this.getActionNumber() + ": " + this.getActualCommand());
        }
    }

    public void handleFailure(CommandFailure commandFailure) {
        this.actualFailure = commandFailure;
        this.runValidation();
    }

    private void awaitCaseModifiedEvent(CaseResponse caseResponse) {
        if (caseResponse.getLastModified() == null) {
            return;
        }
        logger.debug("Awaiting events for test command " + this.getActionNumber() + ": " + this.getActualCommand());
        this.getEventListener().awaitCaseModifiedEvent(caseResponse.getLastModified());
    }

    public String caseInstanceString() {
        return this.caseSnapshotString;
    }

    @Override
    public String tenant() {
        if (this.actualCommand.isBootstrapMessage()) {
            return this.actualCommand.asBootstrapMessage().tenant();
        }
        throw new RuntimeException("This is not a BootstrapCommand");
    }

    @Override
    public Value<?> toJson() {
        return this.actualCommand.toJson();
    }
}

