/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions;

import org.cafienne.actormodel.exception.SerializedException;
import org.cafienne.actormodel.response.CommandFailure;
import org.cafienne.cmmn.test.CaseTestCommand;
import org.cafienne.cmmn.test.TestScript;
import org.cafienne.cmmn.test.assertions.ModelTestCommandAssertion;

public class FailureAssertion
extends ModelTestCommandAssertion {
    public FailureAssertion(CaseTestCommand caseTestCommand) {
        super(caseTestCommand, true);
        if (caseTestCommand.getActualFailure() == null) {
            throw new AssertionError((Object)("Test script expected a failure from the engine in step " + caseTestCommand.getActionNumber() + " [" + caseTestCommand.getActualCommand().getClass().getSimpleName() + "]"));
        }
    }

    public void print() {
        TestScript.debugMessage(this.toString());
    }

    public String toString() {
        return "Result of step " + this.testCommand.getActionNumber() + ": " + this.testCommand.getActualFailure().toJson();
    }

    public SerializedException assertException(Class<? extends Throwable> clazz) {
        CommandFailure commandFailure = this.testCommand.getActualFailure();
        if (commandFailure != null) {
            SerializedException serializedException = commandFailure.exception();
            if (clazz.isAssignableFrom(serializedException.getExceptionClass())) {
                return serializedException;
            }
            throw new AssertionError((Object)("Case returned a command failure with exception of type " + serializedException.getExceptionClass().getName() + ", but we are expecting an exception of type " + clazz.getName()));
        }
        throw new AssertionError((Object)"Case did not return an exception");
    }

    public FailureAssertion assertException(Class<? extends Throwable> clazz, String string) {
        this.assertException(clazz);
        this.assertException(string);
        return this;
    }

    public FailureAssertion assertException(String string) {
        SerializedException serializedException = this.assertException(Exception.class);
        String string2 = serializedException.getMessage();
        if (!string2.contains(string)) {
            throw new AssertionError((Object)("Received a CommandFailure with an unexpected message.\nExpecting :" + string + "\nReceived  :" + string2));
        }
        return this;
    }
}

