/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions;

import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.stream.Collectors;
import org.cafienne.actormodel.event.ModelEvent;
import org.cafienne.cmmn.actorapi.event.CaseModified;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemTransitioned;
import org.cafienne.cmmn.instance.casefile.Path;
import org.cafienne.cmmn.test.TestScript;
import org.cafienne.cmmn.test.filter.EventFilter;

public class PublishedEventsAssertion<E extends ModelEvent> {
    private final List<E> events;

    public PublishedEventsAssertion(List<E> list) {
        this.events = list;
    }

    public PublishedEventsAssertion(PublishedEventsAssertion publishedEventsAssertion) {
        this.events = new ArrayList<E>(publishedEventsAssertion.getEvents());
    }

    public PublishedEventsAssertion assertSize(int n) {
        if (this.events.size() != n) {
            String string = this.events.stream().map(modelEvent -> modelEvent.getClass().getSimpleName()).collect(Collectors.toSet()).toString();
            throw new AssertionError((Object)("Expecting " + n + ", but found " + this.events.size() + " events: " + string));
        }
        return this;
    }

    public PublishedEventsAssertion assertNotEmpty() {
        if (this.events.isEmpty()) {
            throw new AssertionError((Object)"Expecting events, but found none");
        }
        return this;
    }

    private <T extends ModelEvent> boolean filterMatches(Class<T> clazz, EventFilter<T> eventFilter, ModelEvent modelEvent) {
        return clazz.isAssignableFrom(modelEvent.getClass()) && eventFilter.matches(modelEvent);
    }

    public <T extends ModelEvent> T assertEvent(String string, Class<T> clazz, EventFilter<T> eventFilter) {
        for (int i = 0; i < this.events.size(); ++i) {
            ModelEvent modelEvent = (ModelEvent)this.events.get(i);
            if (!this.filterMatches(clazz, eventFilter, modelEvent)) continue;
            return (T)modelEvent;
        }
        throw new AssertionError((Object)string);
    }

    private String cleanPath(String string) {
        int n = string.indexOf(91);
        int n2 = string.indexOf(93);
        if (n > 0 && n2 > n) {
            String string2 = string.substring(0, n) + string.substring(n2 + 1);
            return this.cleanPath(string2);
        }
        return string;
    }

    public CaseFileItemTransitioned assertCaseFileEvent(Path path, EventFilter<CaseFileItemTransitioned> eventFilter) {
        return this.assertEvent("CaseFileItemTransitioned-" + path, CaseFileItemTransitioned.class, caseFileItemTransitioned -> path.matches(caseFileItemTransitioned.getPath()) && eventFilter.matches((CaseFileItemTransitioned)caseFileItemTransitioned));
    }

    public PublishedEventsAssertion assertNoCaseFileEvent(Path path) {
        return this.assertNoCaseFileEvent(path, caseFileItemTransitioned -> true);
    }

    public PublishedEventsAssertion assertNoCaseFileEvent(Path path, EventFilter<CaseFileItemTransitioned> eventFilter) {
        this.filter(CaseFileItemTransitioned.class).getEvents().forEach(caseFileItemTransitioned -> {
            if (path.matches(caseFileItemTransitioned.getPath()) && eventFilter.matches((CaseFileItemTransitioned)caseFileItemTransitioned)) {
                throw new AssertionError((Object)("Did not expect to find a matching case file event on path " + path + ", but found\n" + caseFileItemTransitioned));
            }
        });
        return this;
    }

    public PublishedEventsAssertion assertEventType(Class clazz, int n) {
        int n2 = this.filter(clazz).getEvents().size();
        if (n2 != n) {
            throw new AssertionError((Object)("Expecting " + n + " events of type " + clazz.getSimpleName() + ", but " + n2 + " events found"));
        }
        return this;
    }

    public String enumerateEventsByType() {
        LinkedHashMap<Class, Integer> linkedHashMap = new LinkedHashMap<Class, Integer>();
        this.events.forEach(modelEvent -> linkedHashMap.put(modelEvent.getClass(), linkedHashMap.getOrDefault(modelEvent.getClass(), 0) + 1));
        StringBuilder stringBuilder = new StringBuilder();
        linkedHashMap.forEach((clazz, n) -> stringBuilder.append(clazz.getSimpleName() + ": " + n + "\n"));
        return stringBuilder.toString();
    }

    public void printSummary() {
        TestScript.debugMessage("Found these events:\n" + this.enumerateEventsByType());
    }

    public void printEventList() {
        StringBuffer stringBuffer = new StringBuffer("\nEvents:");
        this.events.forEach(modelEvent -> stringBuffer.append("\n " + this.events.indexOf(modelEvent) + ": " + modelEvent));
        TestScript.debugMessage(stringBuffer + "\n");
    }

    public PublishedEventsAssertion filter(String string) {
        return new PublishedEventsAssertion(this.events.stream().filter((? super T modelEvent) -> modelEvent.getActorId().equals(string)).collect(Collectors.toList()));
    }

    public <T extends ModelEvent> PublishedEventsAssertion<T> filter(Class<T> clazz) {
        return new PublishedEventsAssertion(this.events.stream().filter((? super T modelEvent) -> clazz.isAssignableFrom(modelEvent.getClass())).collect(Collectors.toList()));
    }

    public <T extends E> PublishedEventsAssertion<T> filter(EventFilter<T> eventFilter) {
        return new PublishedEventsAssertion(this.events.stream().filter((? super T modelEvent) -> eventFilter.matches(modelEvent)).collect(Collectors.toList()));
    }

    public PublishedEventsAssertion filter(Instant instant) {
        ArrayList<ModelEvent> arrayList = new ArrayList<ModelEvent>();
        for (int i = 0; i < this.events.size(); ++i) {
            ModelEvent modelEvent = (ModelEvent)this.events.get(i);
            arrayList.add(modelEvent);
            if (!(modelEvent instanceof CaseModified)) continue;
            CaseModified caseModified = (CaseModified)modelEvent;
            if (caseModified.lastModified().equals(instant)) {
                return new PublishedEventsAssertion(arrayList);
            }
            arrayList = new ArrayList();
        }
        return new PublishedEventsAssertion(arrayList);
    }

    public List<E> getEvents() {
        return this.events;
    }

    public String toString() {
        return this.events.toString();
    }
}

