/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.cmmn.test.assertions.file;

import java.util.ArrayList;
import java.util.List;
import java.util.Optional;
import org.cafienne.cmmn.actorapi.event.file.CaseFileItemTransitioned;
import org.cafienne.cmmn.instance.State;
import org.cafienne.cmmn.instance.casefile.Path;
import org.cafienne.cmmn.test.CaseTestCommand;
import org.cafienne.cmmn.test.assertions.ModelTestCommandAssertion;
import org.cafienne.cmmn.test.assertions.PublishedEventsAssertion;
import org.cafienne.cmmn.test.assertions.file.CaseFileAssertion;
import org.cafienne.json.Value;
import org.cafienne.json.ValueList;

public class CaseFileItemAssertion
extends ModelTestCommandAssertion {
    private final Path path;
    private final PublishedEventsAssertion<CaseFileItemTransitioned> events = new PublishedEventsAssertion(new ArrayList());
    private final CaseFileAssertion caseFileAssertion;
    private final boolean isArrayElement;
    private int indexInArray = -1;

    CaseFileItemAssertion(CaseFileAssertion caseFileAssertion, CaseTestCommand caseTestCommand, Path path) {
        super(caseTestCommand);
        this.caseFileAssertion = caseFileAssertion;
        this.path = path;
        this.isArrayElement = path.isArrayElement();
    }

    void addEvent(CaseFileItemTransitioned caseFileItemTransitioned) {
        this.events.getEvents().add(0, caseFileItemTransitioned);
        this.indexInArray = caseFileItemTransitioned.getIndex();
    }

    int getIndexInArray() {
        return this.indexInArray;
    }

    private CaseFileItemAssertion assertIterable() {
        Optional<CaseFileItemTransitioned> optional = this.events.getEvents().stream().filter(caseFileItemTransitioned -> caseFileItemTransitioned.getPath().isArrayElement()).findFirst();
        if (optional == null) {
            throw new AssertionError((Object)("Case file item " + this.getName() + " is expected to be an array, but it is not"));
        }
        return this;
    }

    public CaseFileItemAssertion assertSize(int n) {
        this.assertIterable();
        List<CaseFileItemAssertion> list = this.caseFileAssertion.getArrayElements(this.path);
        if (list.size() != n) {
            throw new AssertionError((Object)("Case file item array " + this.getName() + " is expected to contain " + n + " elements, but it has " + list.size()));
        }
        return this;
    }

    public CaseFileItemAssertion assertCaseFileItem(Path path) {
        Path path2 = new Path(this.path.toString() + "/" + path.toString());
        return this.caseFileAssertion.assertCaseFileItem(path2);
    }

    public CaseFileItemAssertion assertArrayElement(int n) {
        return this.caseFileAssertion.assertCaseFileItem(new Path(this.path.toString() + "[" + n + "]"));
    }

    public CaseFileItemAssertion assertValue(Value<?> value) {
        if (!this.getValue().equals(value)) {
            throw new AssertionError((Object)("The value of case file item " + this.getName() + " does not match the expected value.\nFound:\n" + this.getValue() + "\nExpected:\n" + value));
        }
        return this;
    }

    public CaseFileItemAssertion assertValueType(Class<? extends Value<?>> clazz) {
        if (!this.getValue().getClass().equals(clazz)) {
            throw new AssertionError((Object)("The value of case file item " + this.getName() + " does not match the expected type '" + clazz.getSimpleName() + "', found '" + this.getValue().getClass().getSimpleName() + "' instead"));
        }
        return this;
    }

    public CaseFileItemAssertion assertState(State state) {
        State state2 = this.getState();
        if (!state2.equals((Object)state)) {
            throw new AssertionError((Object)("CaseFileItem " + this.getName() + " is not in state " + state + " but " + state2));
        }
        return this;
    }

    public Value<?> getValue() {
        ValueList valueList = this.getEventValue(CaseFileItemTransitioned::getValue, Value.NULL);
        if (!this.isArrayElement && valueList == Value.NULL) {
            List<CaseFileItemAssertion> list = this.caseFileAssertion.getArrayElements(this.path);
            if (list.isEmpty()) {
                return valueList;
            }
            ValueList valueList2 = new ValueList(new Object[0]);
            list.forEach(caseFileItemAssertion -> valueList2.add(caseFileItemAssertion.getValue()));
            valueList = valueList2;
        }
        return valueList;
    }

    private State getState() {
        return this.getEventValue(CaseFileItemTransitioned::getState, State.Null);
    }

    private String getName() {
        return this.getEventValue(caseFileItemTransitioned -> caseFileItemTransitioned.getPath().getName(), this.path.toString());
    }

    private <T> T getEventValue(EventValuePicker<T> eventValuePicker, T t) {
        if (this.events.getEvents().isEmpty()) {
            return t;
        }
        return eventValuePicker.pick(this.events.getEvents().get(0));
    }

    static interface EventValuePicker<T> {
        public T pick(CaseFileItemTransitioned var1);
    }
}

