/*
 * Decompiled with CFR 0.152.
 */
package org.cafienne.consentgroup.actorapi.command;

import org.cafienne.actormodel.command.BaseModelCommand;
import org.cafienne.actormodel.exception.AuthorizationException;
import org.cafienne.actormodel.exception.InvalidCommandException;
import org.cafienne.actormodel.identity.ConsentGroupUser;
import org.cafienne.consentgroup.ConsentGroupActor;
import org.cafienne.consentgroup.actorapi.ConsentGroupMessage;
import org.cafienne.consentgroup.actorapi.exception.ConsentGroupException;
import org.cafienne.json.ValueMap;

public abstract class ConsentGroupCommand
extends BaseModelCommand<ConsentGroupActor, ConsentGroupUser>
implements ConsentGroupMessage {
    protected ConsentGroupCommand(ConsentGroupUser consentGroupUser, String string) {
        super(consentGroupUser, string);
    }

    protected ConsentGroupCommand(ValueMap valueMap) {
        super(valueMap);
    }

    @Override
    protected ConsentGroupUser readUser(ValueMap valueMap) {
        return ConsentGroupUser.deserialize(valueMap);
    }

    @Override
    public void validate(ConsentGroupActor consentGroupActor) throws InvalidCommandException {
        if (!consentGroupActor.exists()) {
            throw new ConsentGroupException("Not allowed to access this consent group");
        }
        if (!consentGroupActor.isOwner((ConsentGroupUser)this.getUser())) {
            throw new AuthorizationException("You do not have the privileges to perform this action");
        }
    }

    protected void validateNotLastMember(ConsentGroupActor consentGroupActor, String string) {
        if (consentGroupActor.getMembers().size() == 1) {
            throw new ConsentGroupException("Cannot remove group membership for user " + string + ". There must be at least one member.");
        }
    }

    protected void validateNotLastOwner(ConsentGroupActor consentGroupActor, String string) {
        if (consentGroupActor.getOwners().size() == 1 && consentGroupActor.getOwners().contains(string)) {
            throw new ConsentGroupException("Cannot remove group ownership of user " + string + ". There must be at least one group owner.");
        }
    }
}

